# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import graphUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import tableItemsUtil
from cbb.business.operate.expansion import enclosureCommon

def refreshData(context, param):
    '''
    @summary: 刷新2U硬盘框的数据
    '''
    try:
        logger = common.getLogger(context.get("logger"), __file__)
        
        changedId = context.get("input_changed_id")    #当前触发的控件id
        logger.logInfo("input_changed_id: %s" % changedId)
        enclosureNum = int(context.get(changedId))  #获取硬盘框的数量
        logger.logInfo("input 2U enlosure number: %d" % enclosureNum)
        
        #获取新增框的信息列表
        height = 2  #2U硬盘框
        rowId = changedId.split("_")[1]     #上下文获取到的格式为stepId_rowId_colId
        oldCabinetInfoDict = contextUtil.getItem(context, "oldCabinetInfoDict")
        cabinetName = contextUtil.getCabinetNameInRow(context, rowId)
        cabinet = oldCabinetInfoDict.get(cabinetName)
        newEnc2UList = enclosureCommon.getNewEnclosures(context, cabinet, enclosureNum, height)
        logger.logInfo("newEnc2UList:%s" % str(newEnc2UList))
        
        #更新数据
        contextUtil.setItem(context,"newCabinetInfoDict",enclosureCommon.getNewCabinetInfoFor2UEnc(context, newEnc2UList, cabinetName))
        contextUtil.updateSelectedConfig(context, rowId, "newEnc2UList", newEnc2UList)
        contextUtil.updateEclosures(context)
        #判断该机柜是否重复选择配置
        selectedCabinets = contextUtil.getItem(context, "selectedCabinets")
        if selectedCabinets.count(cabinetName) >= 2:
            executeWhenSameCabinet(context,cabinetName, changedId)
        else:
            executeWhenDiffCabinet(context, cabinetName, changedId)
            
        #更新设备图
        encGraphInfoList = common.createEncGraphInfo(context)
        logger.logInfo("encGraphInfoList:%s" % str(encGraphInfoList))
        contextUtil.setItem(context, "encGraphInfoList",encGraphInfoList)
        graphUtil.refreshGraph(context,'EXP',False)
                
        contextUtil.handleSuccess(context)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
def executeWhenSameCabinet(context,cabinetName, changedId):
    '''
    @summary: 刷新机柜的数据
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context) 
    logger.logInfo("select same cabinet")
    
    itemIds = changedId.split("_")  #上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]
    refreshColId = int(colId) + 1
    refreshItemKey = 'return_%d' %refreshColId
    
    #联动2U硬盘框
    newItem = {
            "rule":'0',
            "default":"0"
        }
    
    refreshValue = jsonUtil.dict2JsonStr(newItem)
    context[refreshItemKey] = refreshValue
    return

def executeWhenDiffCabinet(context,cabinetName, changedId):
    '''
    @summary: 刷新机柜的数据
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("select different cabinet")
    
    itemIds = changedId.split("_")  #上下文获取到的格式为stepId_rowId_colId
    colId = itemIds[-1]
    refreshColId = int(colId) + 1
    refreshItemKey = 'return_%d' %refreshColId
    
    #联动4U硬盘框
    curEncHeight = 4 #联动4U硬盘框
    newRule = tableItemsUtil.getEnclosureRule(context, cabinetName, curEncHeight)
    logger.logInfo("the new rule for 4U enclosure: %s" % newRule)
    newItem = {
            "rule":newRule,
            "default":"0"
        }  
    
    refreshValue = jsonUtil.dict2JsonStr(newItem)
    context[refreshItemKey] = refreshValue
    return   