# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import enclosureCommon
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil

def execute(context):
    '''
    @summary: 扩容硬盘框初始化
    '''
    
    try:
        resultDict = {"flag":True, "errMsg":"", "suggestion":""}
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)
        
        #设置内部IP
        devObj = contextUtil.getDevObj(context)
        innerIps = devObj.get("devInnerIpList")
        contextUtil.setItem(context, "innerIps", innerIps)
        logger.logInfo("innerIps:%s" % innerIps)
        
        #针对扩容后再次扩容场景,清除新硬盘柜数量和硬盘框标记
        contextUtil.removeItem(context, "newConfigClustType")
        contextUtil.removeItem(context, "newConfigCtrlNum")
        
        #检查工具与设备的连接
        isPass, errMsg = contextUtil.checkConnection(context)
        if not isPass:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = errMsg, ""
            contextUtil.handleFailure(context, resultDict)
            return
        
        tlv = contextUtil.getTlv(context)
        if tlv is None:
            logger.logNoPass("create tlv connection failure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "dev.conn.failure")
            contextUtil.handleFailure(context, resultDict)
            return
        
        ##直流电源是否连接了不允许的接口-二级级联：无6、7号环路，四级级联：无3号环路
        netRet = enclosureCommon.isDcErrNet(context)
        if not netRet[0]:
            logger.logNoPass("DC power, error connect sas ports: %s ." % ', '.join(netRet[1]))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "dcpower.err.net", ', '.join(netRet[1]))
            contextUtil.handleFailure(context, resultDict)
            return
        
        cli = contextUtil.getCli(context)
        #针对V3R3C20以后版本的资料归一问题
        common.setSpecialMsgInfo(cli, lang, logger)
        
        #获取设备信息
        common.getClsInfoForExpandDisk(context, tlv)
        enclosureCommon.initClsInfoForEnclosures(context, tlv)
        
        #上次扩容系统柜是否完成
        (isFinished, abnormalCtrls) = common.isExpandCtrlFinished(context)
        if not isFinished:
            logger.logNoPass("Expand ctroller is not finished")
            abnormalCtrlInfo = ",".join(abnormalCtrls)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cluster.expand.ctrl.not.finished",abnormalCtrlInfo)
            contextUtil.handleFailure(context, resultDict)
            return
        
        #判断系统框是否达到系统最大柜配置
        if enclosureCommon.checkMaxEnclosureConfig(context, tlv):
            logger.logNoPass("Max config of disk enclosure")
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cluster.max.diskEnclosure.conf")
            contextUtil.handleFailure(context, resultDict)
            return
        
        #是否存在单B链路，即存在硬盘框DAE999        
        checkLinkRet = common.checkEnclosureSingleLink(tlv)
        if not checkLinkRet[0]:
            cabinetInfo = ','.join(checkLinkRet[1])
            logger.logNoPass("Cabinet (%s) exist DAE999 enclosure" %cabinetInfo)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cabinet.wrong.link.conn.sas",cabinetInfo)
            contextUtil.handleFailure(context, resultDict)
            return    
        
        #单个分区内硬盘类型是否相同
        cabinetInfoDict = contextUtil.getItem(context, "oldCabinetInfoDict")
        checkModelRet = enclosureCommon.checkEnclosureModel(cabinetInfoDict)
        if not checkModelRet[0]:
            cabinetInfo = ','.join(checkModelRet[1])
            logger.logNoPass("Cabinet (%s) exist different enclosures" %cabinetInfo)
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "cluster.enclosure.not.match",cabinetInfo)
            contextUtil.handleFailure(context, resultDict)
            return  
        
        ##当前组网是否是标准组网
        errEnclosureList = contextUtil.getItem(context, "errEnclosureList") 
        if len(errEnclosureList) > 0:
            logger.logNoPass("error connect enclosures: %s ." % str(errEnclosureList))
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "error.connet.enclosures", ', '.join(errEnclosureList))
            contextUtil.handleFailure(context, resultDict)
            return
             
        #根据扩容场景,设置扩容流程
        setStepFlow(context)
        
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    
def setStepFlow(context):
    '''
    @summary: 根据扩容场景,设置扩容流程
    '''
    #根据step ID设置界面向导中的步骤

    runStepIdList = []

    runStepIdList.append("notice")
    runStepIdList.append("selectConfig")
    runStepIdList.append("preCheck")
    runStepIdList.append("connectLine")
    runStepIdList.append("joinSystem")
    runStepIdList.append("confirmDiskEnc")
    runStepIdList.append("checkCables")
    runStepIdList.append("postCheck")    
    runStepIdList.append("finished")
    
    context["runStepIdList"] = ",".join(runStepIdList)
    return
