# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
import os


def initData(context):
    '''
    @summary: 移卡完成
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return

    finally:
        deleletMoveCardFile(context)


def deleletMoveCardFile(context):
    logger = common.getLogger(context.get("logger"), __file__)
    baseDir = os.path.abspath("../..")
    needMoveCardFile = os.path.join(baseDir,
                                    config.CFG_DATA_PERSIST_DIR,
                                    contextUtil.getDevObj(context).get('sn') + '_needMoveSasCard')
    if os.path.exists(needMoveCardFile):
        os.remove(needMoveCardFile)
        logger.logInfo("delete file : %s" % needMoveCardFile)