# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from expandDisk.script.moveSasCard.util import checkSysAlarms
from expandDisk.script.moveSasCard.util import postCheckPcieCardPos
from expandDisk.script.moveSasCard.util import postCheckSasCardPos
from expandDisk.script.moveSasCard.util import postCheckSingleLink


# 检查操作项统一入口
def execute(context, param):
    logger = common.getLogger(context.get("logger"), __file__)
    lang = context.get("lan")
    try:
        # 入口参数校验
        if None == param or "" == param:
            raise Exception("empty param!")
        # 获取入口函数
        param = str(param)  # 将Java字符串转换为Python字符串
        execfunc = globals()[param]
        # 入口函数校验
        if None == execfunc:
            raise Exception("in-existed func: " + param)
        if not callable(execfunc):
            raise Exception("in-callable func: " + param)
        # 执行入口函数
        execfunc(context)
        # 记录执行结果
        if False == context["succ"]:
            logger.logException("exec moveSasCardPostCheck func " + param + " result: NOTPASS. errMsg="
                                + context["errMsg"] + ", suggestion=" + context["suggestion"])
        else:
            logger.logInfo("exec moveSasCardPostCheck func " + param + " result: PASS")

        return

    except Exception as ex:
        logger.logException(ex)
        resultDict ={}
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "dev.conn.failure")
        contextUtil.handleFailure(context, resultDict)
        return


def checkSasCardInPosition(context):
    '''
    检查SAS接口卡是否在位
    :param context:
    :return:
    '''
    return postCheckSasCardPos.execute(context)


def checkPCIeCardInPosition(context):
    '''
    检查pcie scale up接口卡是否在位
    :param context:
    :return:
    '''
    return postCheckPcieCardPos.execute(context)


def checkDiskSingleLink(context):
    '''
    检查硬盘单链路
    :param context:
    :return:
    '''
    return postCheckSingleLink.execute(context)


def checkAlarm(context):
    '''
    检查系统告警
    :param context:
    :return:
    '''
    return checkSysAlarms.execute(context)
