# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common

# PCIe Scale-up接口模块
PCIE_SCALE_UP_MODULE = u'2-port 8 Gbit/s PCIe scale-up interface module'

# 12Gb SAS级联模块
SAS_INTERF = u'4x12G SAS QSFP Interface Module'


def execute(context):
    """
    检查是否有空闲槽位可以挪卡
    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    try:
        # 查询接口卡信息
        flag, cliRet, errMsg, interfIdModel = common.getInterfModule(cli, lang)
        if not flag:
            return False, False
        moveCardInfo = contextUtil.getItem(context, "moveCardInfo", {})
        slotInfos = moveCardInfo.get("moveCardInfo", {})
        check, move, notFree, occupiedSlot = checkSlot(slotInfos, interfIdModel)
        contextUtil.setItem(context, "move", move)
        if not move:
            return False, False
        if not check:
            return True, False
        return True, True

    except Exception as exception:
        logger.logException(exception)
        return False, False


def checkSlot(slotInfos, inerfIdModel):
    check = True
    occupiedSlot = []
    notFree = []
    move = []
    for slotinfo in slotInfos:
        srcLoc = slotinfo.get("srcLoc")
        dstLocList = slotinfo.get("dstLocList")
        if not inerfIdModel.get(srcLoc, ""):
            continue
        if inerfIdModel.get(srcLoc, "") != SAS_INTERF:
            check = False
            occupiedSlot.append(srcLoc)
            continue
        freeCheck, dest = isFree(dstLocList, inerfIdModel)
        if not freeCheck:
            check = False
            notFree.append(srcLoc)
            continue
        move.append({"srcLoc": srcLoc, "dstLoc": dest})
    return check, move, notFree, occupiedSlot


def isFree(dstLocList, inerfIdModel):
    dest = ""

    def check(loc):
        return False if inerfIdModel.get(loc, "") else True

    res = filter(check, dstLocList)
    checkResult = True if len(res) != 0 else False
    if checkResult:
        dest = res[0]
    return checkResult, dest


def generateSuss(notFree, occupiedSlot, lang):
    errMsg, sugesstion = "", ""
    if occupiedSlot:
        occupiedErr, occupiedSuss = common.getMsg(lang, "check.sas.faild", "", ",".join(occupiedSlot))
        errMsg += occupiedErr
        sugesstion += occupiedSuss
    if notFree:
        notFreeErr, notFreeSuss = common.getMsg(lang, "check.freeslot.faild", "", ",".join(notFree))
        errMsg += ("," + notFreeErr) if errMsg else notFreeErr
        sugesstion += ("," + notFreeSuss) if sugesstion else notFreeSuss
    return errMsg, sugesstion
