# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def getItems(context):
    """移卡注意事项的内容

    :param context:
    :return:
    """

    logger = common.getLogger(context.get("logger"), __file__)
    try:
        lang = contextUtil.getLang(context)

        makesureItems = []
        makesureItems.append(common.getRes(lang, "make.sure.operate.according.to.tool"))
        makesureItems.append(common.getRes(lang, "make.sure.prepare.pcie.scale.up.card"))
        makesureItems.append(common.getRes(lang, "make.sure.card.powered.off.before.pull.out.card"))
        makesureItems.append(common.getRes(lang, "make.sure.pull.out.one.card.at.each.time"))
        makesureItems.append(common.getRes(lang, "make.sure.move.card.limit.time"))

        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
