﻿# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import common
from cbb.frame.devGraph import dorodaoGraphUtil

'''
初始化更换的备件
'''


def execute(context):
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        logger.logInfo("insert card init data begin")
        retData = {}
        lan = context.get("lan")
        insertCxtInfoList = contextUtil.getItem(context, "moveCardContext", {}).get("insertLoc", [])
        logger.logInfo("insertCxtInfoList is = " + str(insertCxtInfoList))
        insertLoc = []
        engs = []
        for loc in insertCxtInfoList:
            insertLoc.append(loc)
            eng = loc.split(".")[0]
            if not eng in engs:
                engs.append(eng)
        retData["insertLoc"] = ",".join(insertLoc)
        retData["engNum"] = ",".join(engs)
        retData["status"] = common.getRes(lan, "pcie.card.need.insert")
        context["retData"] = jsonUtil.dict2JsonStr(retData)
        context["succ"] = True
        logger.logInfo("insert card init data begin")

        engs.sort()
        propDict = dict(isBack=True, isHdGraph=True, ctrlEngId=engs[0])
        dorodaoGraphUtil.drawGraph(context, propDict)
        insertLocs = filter(lambda loc: engs[0] in loc, insertLoc)
        insertLocs.sort()
        logger.logInfo("insertLocs : %s" % str(insertLocs))
        dorodaoGraphUtil.highLightHardwarePariByLoc(context, insertLocs)
        return

    except Exception as ex:
        logger.logNoPass("repRefresh exception: %s" % ex)
        return
