# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData
from cbb.business.operate.expansion import jsonUtil
import time
import ast

# 进度刷新间隔
INTERVAL = 2
# 进度总剩余时间
TIME_WAIT_INTF_MOVE_CHECK = 15 * 60
TIME_WAIT_INTF_MOVE_CHECK_INTERNAL = 30


def execute(context):
    '''
    检查pcie scale up接口卡是否在位
    :param context:
    :return:
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 进度条
        lang = context.get("lan")
        bord = context.get("bord")
        ConfirmBordUtil = context.get("ConfirmBordUtil")
        common.threadUpProcess(context, TIME_WAIT_INTF_MOVE_CHECK, INTERVAL)
        retData = ast.literal_eval(context["curData"])
        retData = jsonUtil.decodeUtf8ToUnicode(retData)
        locStrs = retData["insertLoc"]
        locations = locStrs.split(",")
        for location in locations:
            logger.logInfo("location is = " + str(location))
            flag,status,result = isIntfOnLoc(context, location, lang)
            if not flag:
                # 刷新状态
                retData["status"] = status
                ConfirmBordUtil.updateStatus(bord,jsonUtil.dict2JsonStr(retData))
                logger.logNoPass("check interface module location time out")
                # 返回检查项结果
                contextUtil.handleFailure(context, result)
                return
        retData["status"] = common.getRes(lang, "pcie.card.insert.ready")
        ConfirmBordUtil.updateStatus(bord,jsonUtil.dict2JsonStr(retData))
        context["retData"] = jsonUtil.dict2JsonStr(retData)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as ex:
        logger.logException(ex)
        raise ex
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)


def isIntfOnLoc(context, insert, lang, logger=None):
    """
    @summary: 检查接口卡是否在位
    """
    resultDict = {}
    startTime = time.time()
    tlv = contextUtil.getTlv(context)
    retData = ast.literal_eval(context["curData"])
    status = common.getRes(lang, "pcie.card.need.insert")
    retData = jsonUtil.decodeUtf8ToUnicode(retData)
    while True:
        time.sleep(TIME_WAIT_INTF_MOVE_CHECK_INTERNAL)
        if (time.time() - startTime) > TIME_WAIT_INTF_MOVE_CHECK:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "not.insert.pcie.card", insert, insert)
            return False,status, resultDict
        res = tlvUtil.getInterfaceModuleRecords(tlv)
        loc = tlvUtil.getRecordsValue(res, tlvData.INTF_MODULE["location"], insert)
        # 检查目标槽位是否PCIe scale-up 接口模块
        if not loc or tlvUtil.getRecordValue(loc,
                                             tlvData.INTF_MODULE["model"]) != tlvData.IntfModelEnum.PCIe_2PORT_BACK:
            continue
        else:
            runningStatus = tlvUtil.getRecordValue(loc[0], tlvData.INTF_MODULE["runningStatus"])
            healthStatus = tlvUtil.getRecordValue(loc[0], tlvData.INTF_MODULE["healthStatus"])
            if tlvData.RUNNING_STATUS_E["RUNNING"] != runningStatus or tlvData.RUNNING_STATUS_E[
                "NORMAL"] != healthStatus:
                status = common.getRes(lang, "sas.card.move.poweron_failed")
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang,
                                                                               "insert.pcie.card.dstloc.not.poweron",
                                                                               insert, insert)
                continue
            else:
                return True,status,{}
