# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.devGraph import dorodaoGraphUtil
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData
from cbb.business.operate.expansion import jsonUtil
import time
import ast

TOTAL_TIME = 30 * 60
TIME_WAIT_INTF_MOVE_CHECK_INTERNAL = 1 * 60
# 进度刷新间隔
INTERVAL = 5


def execute(context):
    '''
    检查sas 接口卡是否在位
    :param context:
    :return:
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        # 进度条
        lang = context.get("lan")
        bord = context.get("bord")
        ConfirmBordUtil = context.get("ConfirmBordUtil")
        retData = ast.literal_eval(context["curData"])
        retData = jsonUtil.decodeUtf8ToUnicode(retData)
        srcLocation = retData["srcLoc"]
        dstLocation = retData["dstLoc"]
        common.threadUpProcess(context, TOTAL_TIME, INTERVAL)
        logger.logInfo("src location is = " + str(srcLocation) + " ,dst location is = " + str(dstLocation))
        #检查是否下电
        resultDict ={}
        interfId = common.getInterfModelId(context,srcLocation)
        if interfId:
            flag ,data = isPowerOff(context,interfId,lang,logger)
            ConfirmBordUtil.updateStatus(bord,data)
            if not flag:
                ConfirmBordUtil.updateButtonStatus(bord,True)
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "move.sas.card.dstloc.not.powerff",
                                                                           srcLocation, srcLocation)
                contextUtil.handleFailure(context, resultDict)
                return

        # 弹出对话框，提示用户移卡
        logger.logInfo("moved is = "+ retData["moved"])
        moved = retData["moved"]
        if moved == "False":
            dialogUtil = context['dialogUtil']
            dialogUtil.showInfoDialog(common.getRes(lang,"moveCard.confirm_msg"))
            retData["moved"] = "True"
            context["curData"] = jsonUtil.dict2JsonStr(retData)

        #检查移卡
        flag, status ,resultDict = isIntfOnLoc(context, dstLocation, srcLocation, lang, logger)
        if not flag:
            logger.logNoPass("check interface module location time out")
            contextUtil.handleFailure(context, resultDict)
            return
        # 刷新状态
        retData["status"] = status
        context["curData"] = jsonUtil.dict2JsonStr(retData)
        data = jsonUtil.dict2JsonStr(retData)
        ConfirmBordUtil.updateStatus(bord,data)
        # 刷新设备图
        propDict = dict(isBack=True, isHdGraph=True, ctrlEngId=retData.get("engNum", ''))
        dorodaoGraphUtil.drawGraph(context, propDict)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as ex:
        logger.logException(ex)
        raise ex
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)


def isIntfOnLoc(context, dstLocation, srcLocation, lang, logger=None):
    """
    @summary: 检查接口卡是否在位
    """
    resultDict = {}
    status = common.getRes(lang, "sas.card.need.move")
    startTime = time.time()
    tlv = contextUtil.getTlv(context)
    while True:
        time.sleep(TIME_WAIT_INTF_MOVE_CHECK_INTERNAL)
        if (time.time() - startTime) > TOTAL_TIME:
            return False,status,resultDict
        res = tlvUtil.getInterfaceModuleRecords(tlv)
        src = tlvUtil.getRecordsValue(res, tlvData.INTF_MODULE["location"], srcLocation)

        # 检查原槽位是否已拔
        if src and tlvUtil.getRecordValue(src[0], tlvData.INTF_MODULE["model"]) == tlvData.IntfModelEnum.SAS_4X12G:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "move.sas.card.srcloc.not.move",
                                                                           srcLocation, srcLocation)
            continue
        # 检查目标槽位是否已插卡
        dst = tlvUtil.getRecordsValue(res, tlvData.INTF_MODULE["location"], dstLocation)
        if not dst or tlvUtil.getRecordValue(dst[0], tlvData.INTF_MODULE["model"]) != tlvData.IntfModelEnum.SAS_4X12G:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "move.sas.card.dstloc.not.in",
                                                                           dstLocation, dstLocation)
            continue
        else:
            runningStatus = tlvUtil.getRecordValue(dst[0], tlvData.INTF_MODULE["runningStatus"])
            healthStatus = tlvUtil.getRecordValue(dst[0], tlvData.INTF_MODULE["healthStatus"])
            if tlvData.RUNNING_STATUS_E["RUNNING"] != runningStatus or tlvData.RUNNING_STATUS_E[
                "NORMAL"] != healthStatus:
                resultDict["flag"] = False
                resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "move.sas.card.dstloc.not.poweron",
                                                                               dstLocation, dstLocation)
                status = common.getRes(lang, "sas.card.move.poweron_failed")
                continue
            else:
                status = common.getRes(lang, "sas.card.move.ready")
                return True, status ,{}


def isPowerOff(context, interfId, lan, logger):
    retData = ast.literal_eval(context["curData"])
    retData = jsonUtil.decodeUtf8ToUnicode(retData)
    startTime = time.time()
    # 下电
    common.powerOff_IntfModule(context, interfId)
    # 刷新界面显示信息
    while True:
        time.sleep(3)
        if (time.time() - startTime) > 2 * 60:
            retData["status"] = common.getRes(lan, "sas.card.move.poweroff.failed")
            return False ,jsonUtil.dict2JsonStr(retData)
        status = common.getInterfRunningStatus(context, tlvData.INTF_MODULE["runningStatus"], interfId)
        # -1 means the card may be pulled out and can not be queried.
        if tlvData.RUNNING_STATUS_E["POWER_OFF"] == status or -1 == status:
            retData["status"] = common.getRes(lan, "sas.card.need.move")
            logger.logInfo("the card " + interfId + " is already power off. check passed.")
            return True ,jsonUtil.dict2JsonStr(retData)
