# -*- coding: UTF-8 -*-
from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.frame.tlv import tlvData

# 进度总剩余时间
LIMIT_TIME = 90
# 进度刷新间隔
INTERVAL = 2


def execute(context):
    '''
    检查硬盘单链路
    :param context:
    :return:
    '''
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        logger.logInfo("check single link begin.")
        resultDict = {}
        lang = context.get("lan")
        common.threadUpProcess(context, LIMIT_TIME, INTERVAL)
        tlv = contextUtil.getTlv(context)
        recs = tlvUtil.getDiskRecords(tlv)
        singleLink = tlvUtil.getRecordsValue(recs, tlvData.DISK["healthStatus"],
                                             tlvData.HEALTH_STATUS_E["SINGLE_LINK_FAULT"])
        logger.logInfo("singleLink is = " + str(singleLink))
        if singleLink:
            resultDict["flag"] = False
            resultDict["errMsg"], resultDict["suggestion"] = common.getMsg(lang, "move.sas.card.single.link")
            contextUtil.handleFailure(context, resultDict)
            return
        contextUtil.handleSuccess(context)
        logger.logPass()
        return
    except Exception as ex:
        logger.logException(ex)
        raise ex
    finally:
        # 进度条刷为完成状态
        common.finishProcess(context)
