﻿# -*- coding: UTF-8 -*-
from cbb.frame.devGraph import dorodaoGraphUtil
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import jsonUtil
from cbb.business.operate.expansion import common

'''
初始化更换的备件
'''


def execute(context):
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        retData = {}
        movCxtInfoList = contextUtil.getItem(context, "move", [])
        logger.logInfo("move card init data begin:%s" % movCxtInfoList)
        lan = context.get("lan")
        if movCxtInfoList:
            thisCardInfo = movCxtInfoList.pop(0)
            retData["srcLoc"] = thisCardInfo.get('srcLoc', '')
            retData["dstLoc"] = thisCardInfo.get('dstLoc', '')
            retData["engNum"] = thisCardInfo.get('srcLoc', '').split(".")[0]
            retData["status"] = common.getRes(lan, "sas.card.move.need.poweroff")
            retData["moved"] = "False"
            context["retData"] = jsonUtil.dict2JsonStr(retData)
            context["succ"] = True
            moveCardContext = contextUtil.getItem(context, "moveCardContext", {})
            moveCardContext["index"] = moveCardContext["index"] + 1
            moveCardContext["srcLoc"] = thisCardInfo.get('srcLoc', '')
            moveCardContext["dstLoc"] = thisCardInfo.get('dstLoc', '')
            contextUtil.setItem(context, "moveCardContext", moveCardContext)

            propDict = dict(isBack=True, isHdGraph=True, ctrlEngId=retData.get("engNum", ''))
            dorodaoGraphUtil.drawGraph(context, propDict)
            dorodaoGraphUtil.highLightHardwarePariByName(context, retData["srcLoc"], retData["dstLoc"])

        logger.logInfo("move card init data begin")

    except Exception as ex:
        logger.logException(ex)
