# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.frame.context import contextUtil


def getItems(context):
    '''
    @summary: 高端扩硬盘框场景获取扩容注意事项的内容
    '''

    try:
        logger = common.getLogger(context.get("logger"), __file__)
        lang = contextUtil.getLang(context)

        makesureItems = []
        makesureItems.append(common.getRes(lang, "expdd.notice.makesure.disk"))

        jsonArray = []
        for item in makesureItems:
            jsonArray.append('{"title":"%s"}' % item)
        context["retData"] = "[%s]" % ",".join(jsonArray)

        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
