# -*- coding: UTF-8 -*-
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import errorCodeMgr


def execute(context):
    """
    扩容控制器初始化
    """
    setStepFlow(context)

    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    root_path = contextUtil.getImportRootDir(context)
    err_msg_mrg_obj = errorCodeMgr.ErrorCodeMgr(root_path, lang, logger)
    contextUtil.setItem(context, 'errCodeMgrObj', err_msg_mrg_obj)

    contextUtil.handleSuccess(context)
    return


def setStepFlow(context):
    """
    根据扩容场景,设置扩容流程
    """
    run_steps = []
    run_steps.extend([
        "selectExpandScm",
        "doExpandScm",
        "finished",
    ])
    context["runStepIdList"] = ",".join(run_steps)
    return
