# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion import config
from cbb.business.operate.expansion import jsonUtil
from cbb.common.conf.productConfig import DEF_SMART_DEPTH
from cbb.frame.base import baseUtil
from cbb.frame.base.config import NEW_DORADO, OCEAN_STOR_MICRO_DEVS
from cbb.frame.context import contextUtil
from cbb.frame.tlv import tlvUtil
from cbb.common.conf import productConfig
from cbb.business.product.product_selector import init_product_adapter
from cbb.frame.checkitem.context_adapter import ExpansionContext


def execute(context):
    """针对不同扩容场景指定对应的流程配置

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    try:
        expansion_context = ExpansionContext(context)
        init_product_adapter(expansion_context.get_context())
        contextUtil.removeItem(context, contextUtil.SSH_CONNECTOR)
        contextUtil.removeItem(context, contextUtil.CLI_CONNECTION)
        tlv = contextUtil.getTlv(context)
        cli = contextUtil.getCli(context)
        lang = contextUtil.getLang(context)
        product_model = tlvUtil.getProductModel(tlv)
        product_version = tlvUtil.getProductVersion(tlv)
        internal_model = ""
        if product_version >= productConfig.VersionManager.V5_MIDDLE_SWITCH:
            origin_dev_info = tlvUtil.getInternalDeviceInfo(tlv)
            internal_model = tlvUtil.getInternalPdtModel(origin_dev_info)
        contextUtil.setItem(context, "internalModel", internal_model)
        contextUtil.setItem(context, "productVersion", product_version)
        logger.logInfo("Version:{}, model:{}".format(product_version, product_model))
        is_dorado = common.isDorado(product_model)
        contextUtil.setItem(context, "isDorado", is_dorado)

        # dorado V6 获取详细设备形态
        set_dorado_v6_detail(context, product_model, tlv)

        # 保存产品类型信息到上下文
        contextUtil.setItem(context, "productModel", product_model)

        contextUtil.setItem(context, "is_computing_dev", baseUtil.is_computing_dev(product_model))

        if baseUtil.isDoradoV6Dev(product_model):
            save_enclosure_redundant_info(context, logger, cli, lang)

        ctrl_enclosure_model = tlvUtil.getCtrlEnclosureModel(tlv)
        logger.logInfo("ctrlEnclosureModel:%s" % str(ctrl_enclosure_model))

        contextUtil.setItem(context, "isV5V6HighEnd", baseUtil.isV5V6HighEnd(product_model))
        contextUtil.setItem(context, "isFullBayDeliverPdt", baseUtil.isFullBayDilverProduct(product_model))

        sas_enc_depth, smart_enc_depth = tlvUtil.getMaxExpansionDepth(tlv)
        smart_depth = smart_enc_depth if smart_enc_depth else DEF_SMART_DEPTH
        contextUtil.setItem(context, "deepth", sas_enc_depth)
        contextUtil.setItem(context, "smart_depth", smart_depth)
        power_type = tlvUtil.getPowerType(tlv)
        contextUtil.setItem(context, "powerType", power_type)
        contextUtil.setItem(context, "support4UDiskEnclosure", False)
        logger.logInfo("Sas enclosure max deepth: %s, smart enclosure max "
                       "deepth: %s,power type: %s" % (str(sas_enc_depth),
                                                      str(smart_enc_depth),
                                                      str(power_type)))
        # 高端整柜场景
        if baseUtil.isFullBayDilverProduct(product_model):
            processes_conf_list = getHighEndConfList(context)
        else:
            version = tlvUtil.getFullProductVersion(tlv)
            spc_version = common.getSPCVersion(version)
            contextUtil.setItem(context, 'productModelSPCVer', (product_model, spc_version))

            processes_conf_list = getCommonConfList(context)

        logger.logInfo("processesConfList:%s" % str(processes_conf_list))
        context["processesCfg"] = '[{"name":"","icon":"","desc":"","process":%s}]' % jsonUtil.list2JsonArray(
            processes_conf_list)
        contextUtil.handleSuccess(context)
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def set_dorado_v6_detail(context, product_model, tlv):
    if baseUtil.isDoradoV6Dev(product_model):
        detailed_dorado_pdt_model = tlvUtil.getDoradoV6ProductModel(tlv)
        contextUtil.setItem(context, "detailedDoradoPdtModel", detailed_dorado_pdt_model)
        contextUtil.setItem(context, "isDoradoV6", True)


def getCommonConfList(context):
    """ V5/V6 中低端扩容配置文件

    :param context: 上下文
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    processesConfList = []
    currScene = contextUtil.getSceneArgStrValue(context,
                                                config.SCENE_EXPAND_KEY)
    logger.logInfo("currScene: %s" % currScene)
    if currScene == config.SCENE_EXPAND_ENCLOSURE:
        processesConfList.append(common.getProcessConfDict(
            "expandDisk/diskEnclosure_dorado.xml"))

    elif currScene == config.SCENE_EXPAND_CTRL:
        processesConfList.append(common.getProcessConfDict(
            "expandCtrl/expandCtrl_dorado.xml"))
    elif currScene == config.SCENE_EXPAND_DD:
        processesConfList.append(getExpandDDConf(context))
    elif currScene == config.SCENE_EXPAND_SCM:
        processesConfList.append(get_expand_scm_conf())
    elif currScene is None:  # non-toolbox start
        processesConfList.append(common.getProcessConfDict(
            "expandDisk/diskEnclosure_dorado.xml"))
        processesConfList.append(common.getProcessConfDict(
            "expandCtrl/expandCtrl_dorado.xml"))
        processesConfList.append(getExpandDDConf(context))
        processesConfList.append(get_expand_scm_conf())

    return processesConfList


def getHighEndConfList(context):
    """V5/V6高端扩容配置文件

    :param context: 上下文
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    processesConfList = []
    currScene = contextUtil.getSceneArgStrValue(context,
                                                config.SCENE_EXPAND_KEY)
    logger.logInfo("currScene: %s" % currScene)
    if currScene == config.SCENE_EXPAND_ENCLOSURE:
        processesConfList.append(get_exp_disk_bay_conf(context))
    elif currScene == config.SCENE_EXPAND_BAY:
        # 高端扩容硬盘柜
        processesConfList.append(common.getProcessConfDict(
            "expandDisk/diskBay.xml"))
    elif currScene == config.SCENE_EXPAND_CTRL:
        processesConfList.append(common.getProcessConfDict(
            "expandCtrl/expandCtrl_dorado.xml"))
    elif currScene == config.SCENE_EXPAND_DD:
        processesConfList.append(getExpandDDConf(context))
    elif currScene == config.SCENE_EXPAND_SCM:
        processesConfList.append(get_expand_scm_conf())
    elif currScene is None:  # non-toolbox start
        processesConfList.append(get_exp_disk_bay_conf(context))
        processesConfList.append(common.getProcessConfDict(
            "expandCtrl/expandCtrl_dorado.xml"))
        processesConfList.append(getExpandDDConf(context))
        processesConfList.append(get_expand_scm_conf())

    return processesConfList


def get_expand_scm_conf():
    return common.getProcessConfDict("expandScm/expandScm.xml")


def getExpandDDConf(context):
    """
    扩容硬盘域配置文件
    <p>新融合和微存储混闪支持性能层

    :param context:
    :return:
    """
    internal_model = common.getInternalProductModel(context)
    if contextUtil.getItem(context, "productModel") in NEW_DORADO \
            or baseUtil.is_micro_flashing_dev(internal_model):
        return common.getProcessConfDict("expandDD/expandSmartPool.xml")
    elif contextUtil.getItem(context, "isDoradoV6"):
        return common.getProcessConfDict("expandDD/expandStoragePool.xml")
    else:
        return common.getProcessConfDict("expandDD/expandDD.xml")


def get_exp_disk_bay_conf(context):
    """整柜场景配置文件

    :param context:
    :return:
    """
    # 新融合整柜场景和V5逻辑一样
    tlv = contextUtil.getTlv(context)
    product_model = tlvUtil.getProductModel(tlv)
    if contextUtil.getItem(context, "isDoradoV6") and \
            product_model not in NEW_DORADO:
        return common.getProcessConfDict(
            "expandDisk/diskEncAndBayForHighEnd.xml")
    else:
        return common.getProcessConfDict(
            "expandDisk/diskEncAndBayForV5HighEnd.xml")


def save_enclosure_redundant_info(context, logger, cli, lang):
    # 保存扩容规格到上下文
    cfg_data = common.get_expansion_config_data(logger)
    logger.logInfo("expansion config data is %s" % cfg_data)
    if not cfg_data:
        logger.logInfo("expdd.check.config.data.nil.cfgData")
    else:
        contextUtil.setItem(context, "expCfgData", cfg_data)

    # 新融合不支持框级冗余
    tlv = contextUtil.getTlv(context)
    product_model = tlvUtil.getProductModel(tlv)
    if product_model in NEW_DORADO + OCEAN_STOR_MICRO_DEVS:
        contextUtil.setItem(context, "hasEnclosureRedundant", False)
        return

    # 检查是否有框级冗余硬盘域
    has_enclosure_redundant = False
    if cfg_data:
        for data in cfg_data:
            disk_domain = data.get("domainId")
            ret_flag, is_enc_redu, err_msg = common \
                .isEnclosureRedundancyStrategy(cli, disk_domain, lang,
                                               logger)
            if ret_flag and is_enc_redu:
                has_enclosure_redundant = True
                break

    contextUtil.setItem(context, "hasEnclosureRedundant",
                        has_enclosure_redundant)
