# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

import re


def exec_host_cmd(cli, cmd, log_result=True):
    if not cli.isConnected():
        cli.reConnect()
    return cli.execCmd(cmd) if log_result else cli.execNoLog(cmd)


def query_disks(context):
    cli = context.get("SSH")
    ret = exec_host_cmd(cli, "show disk general")
    disk_list = get_horizontal_cli_ret(ret)
    context["disks"] = disk_list
    return True, disk_list


def get_horizontal_cli_ret(cli_ret):
    try:
        headline = ""
        i = 0
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        for line in cli_ret_list:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cli_ret_list) - 1:
            return []

        title = cli_ret_list[i - 1]
        field_words = cli_ret_list[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0

        while start_pos <= len(headline):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))
        required_line_len = tuple_idxs[-1][0]
        dict_list = []

        for line in field_words:
            if ":/>" in line:
                break
            if re.search("^-+(\s+-+)*\s*$", line):
                continue
            if len(line.strip()) == 0:
                continue
            if len(line) <= required_line_len:
                continue
            values = []
            for item in tuple_idxs:
                values.append(line[item[0]:item[1]].strip().decode("utf8"))
            dict_list.append(dict(zip(keys, values)))
        return dict_list
    except:
        return []
