/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.exception;

import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityResMgr;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityType;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;

public class UserStatusException
extends RuntimeException {
    public static final String PWD_EXPIRED = "conn.userdatus.pwd.expired";
    public static final String PWD_EXPIRING = "conn.userdatus.pwd.expiring";
    public static final String PWD_INITIAL = "conn.userdatus.pwd.initial";
    private static final long serialVersionUID = 8992894090867439021L;
    private String errorId = "";
    private String des = "--";

    public UserStatusException(String msgId) {
        this.errorId = msgId;
        this.setActualDes(msgId, PwdSecurityUserScene.Tool);
    }

    public UserStatusException(String msgId, PwdSecurityUserScene scene) {
        this.errorId = msgId;
        this.setActualDes(msgId, scene);
    }

    private void setActualDes(String msgId, PwdSecurityUserScene scene) {
        if (PWD_EXPIRED.equals(msgId)) {
            this.des = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_EXPIRED, scene);
        }
        if (PWD_EXPIRING.equals(msgId)) {
            this.des = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_WILL_EXPIRE, scene);
        }
        if (PWD_INITIAL.equals(msgId)) {
            this.des = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.INIT_PWD_NOT_CHANGE, scene);
        }
    }

    public String getDes() {
        return this.des;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public String getErrorId() {
        return this.errorId;
    }
}

