/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.factory;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.protocol.factory.RestConnector;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.ism.tool.protocol.factory.SshConnector;
import com.huawei.ism.tool.protocol.factory.SshForwardConnector;
import com.huawei.ism.tool.protocol.factory.TlvConnector;
import java.util.List;

public final class ConnectorFactory {
    private static final ConnectorFactory INSTANCE = new ConnectorFactory();

    private ConnectorFactory() {
    }

    public static ConnectorFactory getInstance() {
        return INSTANCE;
    }

    public SshForwardConnector createSshForwardConnector(DevNode dev) {
        return new SshForwardConnector(dev);
    }

    public SshConnector createSshConnector(String sshHostname, int port, String username, String password) {
        return new SshConnector(sshHostname, port, username, password);
    }

    public TlvConnector createTlvConnector(String ip, int port, String username, String password, Boolean isSSL) {
        return new TlvConnector(ip, port, username, password, isSSL);
    }

    public TlvConnector createTlvConnectorSVP(String svpIp, String svpPort, String svpSession, String deviceType, String sn) {
        return new TlvConnector(svpIp, svpPort, svpSession, deviceType, sn);
    }

    public TlvConnector createTlvConnector(List<String> ipList, int port, String username, String password, Boolean isSSL) {
        return new TlvConnector(ipList, port, username, password, isSSL);
    }

    public TlvConnector createTlvConnector(String ip, int port, String username, String password, String sslVersion) {
        return new TlvConnector(ip, port, username, password, sslVersion);
    }

    public TlvConnector createTlvConnector(List<String> ipList, int port, String username, String password, String sslVersion) {
        return new TlvConnector(ipList, port, username, password, sslVersion);
    }

    public SftpConnector createSftpConnector(String ip, int port, String username, String password) {
        DevNode devNode = DeviceLocator.getDevNodeByKey((String)ip);
        if (devNode != null) {
            return new SftpConnector(EntityUtils.toOldDev(devNode));
        }
        return new SftpConnector(ip, port, username, password);
    }

    public SftpConnector createSftpConnector(String ip, int port, String username, String password, String sn) {
        DevNode devNode = DeviceLocator.getDevNodeByKey((String)ip);
        if (devNode != null) {
            return new SftpConnector(EntityUtils.toOldDev(devNode));
        }
        return new SftpConnector(ip, port, username, password, sn);
    }

    public SftpConnector createSftpConnector(DevNode devNode) {
        return new SftpConnector(EntityUtils.toOldDev(devNode));
    }

    public SftpConnector createSftpConnector(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return new SftpConnector(devNode);
    }

    public SftpConnector createSftpConnector(com.huawei.ism.tool.obase.entity.DevNode devNode, boolean isOnlySftp) {
        return new SftpConnector(devNode, isOnlySftp);
    }

    @Deprecated
    public RestConnector createRestConnector(String uri, String username, String password, String scope) {
        return new RestConnector(uri, username, password, scope);
    }
}

