/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaVisionRestConnect
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(MetaVisionRestConnect.class);
    private static final String HTTPS_PREFIX = "https://";
    private static final String PREFIX = "/fce";
    private static final String SESSION_URI = "/framework/v1/iam/auth/login";
    private static final String LOGOUT_URI = "/logout";
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.singletonList("04040183");

    public MetaVisionRestConnect(DevNode devNode) {
        super(devNode);
        this.uri = HTTPS_PREFIX + RestUtil.processIPByURL(devNode.getIp()) + PREFIX + SESSION_URI;
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + RestUtil.processIPByURL(this.devNode.getIp()) + PREFIX;
    }

    @Override
    public void logOut() {
        String url = this.getBaseUrl() + LOGOUT_URI;
        try {
            log.info("start to logout for metavision device with ip :{}", (Object)this.devNode.getIp());
            this.execPost(url, "");
            log.info("logout success for metavision device with ip :{}", (Object)this.devNode.getIp());
        }
        catch (ToolException e) {
            log.error("logout fail for metavision device with ip : {}", (Object)this.devNode.getIp(), (Object)e);
        }
    }

    @Override
    public void closeSession() {
        super.closeSession();
        RestConnectionManager.releaseFceConnection(this.devNode);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        if (this.devNode.is2910V7()) {
            req.addParam("username", this.devNode.getLoginUser().getUserName());
            req.addParam("password", this.devNode.getLoginUser().getPassword());
        } else {
            req.addParam("username", this.devNode.getMetaVisionUser().getUserName());
            req.addParam("password", this.devNode.getMetaVisionUser().getPassword());
        }
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage()) ? "en-us" : "zh-cn");
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) {
        if (resp == null) {
            return false;
        }
        log.info("check fusioncube meta login result.");
        String content = resp.getContent();
        if (StringUtils.isNULLStr(content)) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        String errorCode = this.getJsonValue("code", json);
        if (!"0".equals(errorCode)) {
            return false;
        }
        JSONObject dataContent = json.getJSONObject("data");
        String token = this.getJsonValue("token", dataContent);
        if (StringUtils.isNULLStr(token)) {
            log.error("login failed,resp={}", (Object)content);
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        JSONObject json;
        String code;
        String content = resp.getContent();
        if (!StringUtils.isNULLStr(content) && NEED_RE_LOGIN_ERROR_CODE.contains(code = (json = new JSONObject(content)).getStringOrDefault("code", ""))) {
            log.info("start to relogin.");
            return true;
        }
        return false;
    }
}

