/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv.exception;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ResourceBundle;

public class TLVException
extends RuntimeException {
    private static final long serialVersionUID = 1669878879930449669L;
    private String errorMessage = "";
    private long errorId = -1L;
    private final transient ResourceBundle errorResourceBundle = ResourceBundle.getBundle("config.errorInfo");

    public TLVException(String message, Throwable cause) {
        super(cause);
        this.errorMessage = message;
    }

    public TLVException(long errorID, Throwable cause) {
        super(cause);
        this.errorId = errorID;
        this.errorMessage = this.getErrorMsg(this.errorId);
    }

    public TLVException(long errorID) {
        this(errorID, (Throwable)null);
    }

    public TLVException(String errorMsg) {
        super(errorMsg);
        this.errorMessage = errorMsg;
    }

    public String getErrorMessage() {
        if (null != this.errorMessage && !"".equals(this.errorMessage)) {
            return this.errorMessage;
        }
        return this.getErrorMsg(this.errorId);
    }

    private String getErrorMsg(long errorMsgId) {
        String msg = "--";
        try {
            msg = this.errorResourceBundle.getString(String.valueOf(errorMsgId));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("getErrorMsg error!" + e);
        }
        return msg;
    }

    @Override
    public String toString() {
        ToolLoggerFactory.getLogger(this.getClass()).info("this is test super :" + super.toString());
        if (this.errorId != -1L) {
            return "TLVException:ERRORCODE=" + this.errorId;
        }
        return "TLVException:ERROR MESSAGE=" + this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public long getErrorId() {
        return this.errorId;
    }
}

