/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack;

import com.huawei.ism.tool.bizpack.IProcessFilter;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.support.ProcessExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstance {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstance.class);
    private ProcessInfo processInfo = new ProcessInfo();
    private volatile boolean processing = false;
    private volatile boolean over = false;
    private ProcessExecutor executor = null;
    private Object processResult = null;
    private NodeResult currentNodeResult = null;
    private List<IProcessFilter> processFilters = new ArrayList<IProcessFilter>();
    private Map<String, Object> processEnv = new HashMap<String, Object>();
    private List<IProcessListener> processListeners = new ArrayList<IProcessListener>();

    public ProcessInstance(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public Object getEnvData(String key) {
        return this.processEnv.get(key);
    }

    public int getNodeNum() {
        return this.processInfo.getNodeItems().size();
    }

    public Object getProcessResult() {
        if (this.processing || !this.over) {
            return null;
        }
        return this.processResult;
    }

    public void process() {
        this.processing = true;
        this.preStart();
        List<NodeItem> nodeItems = this.processInfo.getNodeItems();
        for (NodeItem currentItem : nodeItems) {
            if (!this.processStep(currentItem) && currentItem.isFailExit()) break;
        }
        this.afterfinish();
        this.retrieveProcessResult();
        this.processing = false;
        this.over = true;
    }

    private void retrieveProcessResult() {
        this.processResult = this.processEnv.get("__process_result");
        if (this.processResult == null && this.currentNodeResult != null) {
            this.processResult = this.currentNodeResult.getResult();
        }
    }

    public void setProcessEnv(Map<String, Object> processEnv) {
        this.processEnv = processEnv;
    }

    public void addProcessListeners(List<IProcessListener> listeners) {
        this.processListeners.addAll(listeners);
    }

    private void preStart() {
        for (IProcessListener listener : this.processListeners) {
            listener.preStart(this);
        }
    }

    private void afterfinish() {
        for (IProcessListener listener : this.processListeners) {
            listener.afterFinish(this);
        }
    }

    private boolean processStep(NodeItem nodeItem) {
        log.info("start process step {}", (Object)nodeItem.getDescription());
        if (!this.checkFilter(nodeItem)) {
            return false;
        }
        for (IProcessListener nodeListener : this.processListeners) {
            nodeListener.stepIn(nodeItem);
        }
        this.currentNodeResult = this.executePyScript(nodeItem);
        for (IProcessListener nodeListener : this.processListeners) {
            nodeListener.stepOut(this.currentNodeResult);
        }
        log.info("process step {} result:{}.", (Object)nodeItem.getDescription(), (Object)this.currentNodeResult.isSuccess());
        return this.currentNodeResult.isSuccess();
    }

    public NodeResult executePyScript(NodeItem nodeItem) {
        return this.executor.execute(nodeItem, this.processEnv);
    }

    private boolean checkFilter(NodeItem nodeItem) {
        if (this.processFilters == null) {
            return true;
        }
        for (IProcessFilter filter : this.processFilters) {
            if (filter.isNeedProcess(nodeItem)) continue;
            return false;
        }
        return true;
    }

    public void setProcessFilters(List<IProcessFilter> processFilters) {
        this.processFilters = processFilters;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean isOver() {
        return this.over;
    }

    void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public void setExecutor(ProcessExecutor executor) {
        this.executor = executor;
    }

    public ProcessExecutor getExecutor() {
        return this.executor;
    }
}

