/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.connection;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.bizpack.wizardparse.connection.DeleteRequest;
import com.huawei.ism.tool.bizpack.wizardparse.connection.GetRequest;
import com.huawei.ism.tool.bizpack.wizardparse.connection.HttpSession;
import com.huawei.ism.tool.bizpack.wizardparse.connection.PostRequest;
import com.huawei.ism.tool.bizpack.wizardparse.connection.PutRequest;
import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.RequestInfo;
import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.ResponseInfo;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.hc.core5.http.Header;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.slf4j.Logger;

@Deprecated
public class RestConnection {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RestConnection.class);
    private static final Integer TIMEOUTSTATUSCODE = -401;
    private static final String LOGIN_PWD_ERROR = "The user name or password is incorrect";
    private String uri;
    private String loginUri;
    private String userName;
    private String passW;
    private String scope;
    private HttpSession session;
    private DevNode devNode;
    private int foradPort = 0;
    private static final int SUCCESS_FLAG = 0;
    private boolean isLogined = false;
    private Locale loc = LanguageManager.getInstance().getCurrentLanguage();
    private MultiRouteManager routeMgr = null;
    private String proxySvpIp = "";

    public RestConnection(String uri, String userName, String pwd, String scope) {
        this.uri = uri;
        this.userName = userName;
        this.passW = pwd;
        this.scope = scope;
        if (scope == null || scope.isEmpty()) {
            this.scope = "0";
        }
        this.disableHttpLog();
    }

    public RestConnection(String uri, DevNode devNode) {
        this(uri, devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword(), null);
        this.devNode = devNode;
        this.disableHttpLog();
    }

    public RestConnection(DevNode devNode) {
        this(RestUtil.getloginUri((DevNode)devNode), devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword(), null);
        this.devNode = devNode;
        this.disableHttpLog();
    }

    public void createForwardOnNeeded(DevNode node) {
        if (node.getSshForwardList() != null && !node.getSshForwardList().isEmpty()) {
            try {
                int portNew;
                this.routeMgr = new MultiRouteManager(node.getSshForwardList());
                this.foradPort = portNew = this.routeMgr.createForwarderLocalPort(node.getIp(), 8088);
            }
            catch (Exception e) {
                if (this.routeMgr != null) {
                    this.routeMgr.close();
                }
                LOGGER.error("create forward error", (Throwable)e);
            }
        }
    }

    public boolean isLogin() {
        return this.isLogined;
    }

    public synchronized void reLogin() throws ToolException {
        try {
            this.closeSession();
            this.isLogined = false;
        }
        catch (Exception e1) {
            LOGGER.error("in reconnect close Connection error!", (Throwable)e1);
        }
        this.login();
    }

    public void reLoginWithTimeOut() throws ToolException {
        this.uri = this.loginUri;
        try {
            this.session.close();
            this.session = null;
            this.isLogined = false;
        }
        catch (Exception e1) {
            LOGGER.error("reLogin in reconnect close Connection error!", (Throwable)e1);
        }
        this.login();
    }

    public void reporaceAddressOnForward(RequestInfo req) {
        if (this.foradPort != 0) {
            req.setUrl(req.getUrl().replace(this.devNode.getIp(), "127.0.0.1").replace(String.valueOf("8088"), String.valueOf(this.foradPort)));
        }
    }

    public ResponseInfo login() throws ToolException {
        if (null == this.uri) {
            LOGGER.info("url is null");
            return null;
        }
        PostRequest req = new PostRequest(this.uri);
        req.addParam("username", this.userName);
        req.addParam("password", this.passW);
        req.addParam("scope", this.scope);
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(req);
        ResponseInfo resp = null;
        try {
            this.initSession();
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
            throw new ToolException(e.getMessage());
        }
        try {
            resp = this.session.sendRequest1(req);
            this.checkLoginResult(resp);
        }
        catch (IOException e) {
            this.closeSession();
            LOGGER.info("error.conn", (Throwable)e);
            return resp;
        }
        catch (JSONException je) {
            LOGGER.error("response is not json string", (Throwable)je);
            return resp;
        }
        Long obj = (Long)resp.getContentMap().get("errorCode");
        if (obj != null && 0L == obj) {
            this.isLogined = true;
            this.loginUri = this.uri;
        }
        return resp;
    }

    public ResponseInfo loginSvpProxy() throws ToolException {
        if (!this.checkSvpProxyCanProcessLogin()) {
            return null;
        }
        PostRequest req = new PostRequest(this.uri);
        req.addParam("username", this.userName);
        req.addParam("password", this.passW);
        req.addParam("scope", this.scope);
        MultiRouteNode lastNode = (MultiRouteNode)this.devNode.getSshForwardList().remove(this.devNode.getSshForwardList().size() - 1);
        String ipCache = this.devNode.getIp();
        req.setUrl(this.replaceHostForSvp(req.getUrl(), lastNode.getHost()));
        this.devNode.setIp(lastNode.getHost());
        ResponseInfo resp = null;
        boolean accessSuccess = false;
        try {
            this.createForwardOnNeeded(this.devNode);
            this.reporaceAddressOnForward(req);
            this.initSession();
            try {
                resp = this.session.sendRequest1(req);
                this.checkLoginResult(resp);
            }
            catch (JSONException | IOException e) {
                this.closeSession();
                LOGGER.error("Login device by rest failed:", (Throwable)e);
                ResponseInfo responseInfo = resp;
                if (!accessSuccess) {
                    this.devNode.setIp(ipCache);
                    this.devNode.getSshForwardList().add(lastNode);
                }
                return responseInfo;
            }
            this.errorCodeCheck(resp);
            accessSuccess = true;
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
            throw new ToolException("No trusted certificate found");
        }
        finally {
            if (!accessSuccess) {
                this.devNode.setIp(ipCache);
                this.devNode.getSshForwardList().add(lastNode);
            }
        }
        this.proxySvpIp = lastNode.getHost();
        return resp;
    }

    private String replaceHostForSvp(String originUrl, String svpHost) {
        if (StringUtils.isNULLStr((String)svpHost)) {
            return originUrl;
        }
        return originUrl.replace(URI.create(originUrl).getHost(), svpHost);
    }

    private boolean checkSvpProxyCanProcessLogin() {
        if (this.uri == null) {
            LOGGER.info("url is null");
            return false;
        }
        if (!this.devNode.getHighDevSVPModuleInfo().endsWith("hassvp")) {
            LOGGER.info("not svp device");
            return false;
        }
        if (this.devNode.getSshForwardList() == null || this.devNode.getSshForwardList().isEmpty()) {
            LOGGER.info("ssh forward list is empty");
            return false;
        }
        return true;
    }

    private void initSession() throws CertificateException {
        if (this.session == null) {
            this.session = HttpSession.createNewSession(this.devNode);
        }
    }

    public String getPassword() {
        return AESEncrypt.decrypt(this.passW);
    }

    public ResponseInfo execGet(String url, String param) throws ToolException {
        return this.execGet(url, param, null);
    }

    public ResponseInfo execGetWithNoLog(String url, String param) throws ToolException {
        RestParamEntity entity = new RestParamEntity(false);
        return this.execGet(url, param, entity);
    }

    public ResponseInfo execGet(String url, String param, RestParamEntity entity) throws ToolException {
        GetRequest req = new GetRequest(url);
        return this.exeGet(req, param, entity);
    }

    public ResponseInfo execGetDivisionLang(String url, String param) throws ToolException {
        GetRequest req = new GetRequest(url);
        req.setHeader("Accept-Language", this.loc.toLanguageTag());
        return this.exeGet(req, param, null);
    }

    private ResponseInfo exeGet(RequestInfo req, String param, RestParamEntity entity) throws ToolException {
        if (null == req || StringUtils.isNULLStr((String)req.getUrl())) {
            LOGGER.info("url is null");
            return null;
        }
        req.setUrl(this.replaceHostForSvp(req.getUrl(), this.proxySvpIp));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToRelogin(param, entity, req, resp);
        return resp;
    }

    public PyDictionary execGetForBig(String url, String param) throws ToolException {
        ResponseInfo resp = this.execGet(url, param);
        if (null == resp) {
            LOGGER.info("url is null");
            return null;
        }
        JSONObject json = new JSONObject(resp.getContent());
        JSONArray data = null;
        try {
            data = json.getJSONArray("data");
        }
        catch (JSONException je) {
            data = new JSONArray();
        }
        JSONObject error = json.getJSONObject("error");
        PyList pylist = new PyList();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = (JSONObject)data.get(i);
            Iterator it = obj.keys();
            PyDictionary pymap = new PyDictionary();
            while (it.hasNext()) {
                String key = (String)it.next();
                pymap.put((Object)key, obj.get(key));
            }
            pylist.append((PyObject)pymap);
        }
        Iterator iterror = error.keys();
        PyDictionary errormap = new PyDictionary();
        while (iterror.hasNext()) {
            String key = (String)iterror.next();
            errormap.put((Object)key, error.get(key));
        }
        PyDictionary pymapAll = new PyDictionary();
        pymapAll.put((Object)"data", (Object)pylist);
        pymapAll.put((Object)"error", (Object)errormap);
        return pymapAll;
    }

    private ResponseInfo requestProcess(String param, RequestInfo request, RestParamEntity restParamEntity) {
        boolean isLog = true;
        if (null == this.session || !this.isLogined) {
            LOGGER.info("connection is closed...");
            return new ResponseInfo();
        }
        this.reporaceAddressOnForward(request);
        LOGGER.info("command: {}", (Object)SensitiveInfoFilter.filter((String)param));
        this.addParam(param, request);
        request.setHeader("iBaseToken", this.session.getSessionID());
        ResponseInfo response = null;
        try {
            response = this.session.sendRequest1(request);
            if ((null == restParamEntity || restParamEntity.isWithLog()) && LOGGER.isInfoEnabled()) {
                LOGGER.info("ResponseInfo : " + response.getContent());
            }
        }
        catch (IOException e) {
            if (!(request instanceof DeleteRequest) || !request.getUrl().equals(this.loginUri)) {
                this.closeSession();
            }
            LOGGER.info("error.conn", (Throwable)e);
            return response;
        }
        return response;
    }

    private void addParam(String param, RequestInfo request) {
        if (param != null && !param.isEmpty()) {
            JSONObject json = new JSONObject(param);
            try {
                Iterator nameItr = json.keys();
                while (nameItr.hasNext()) {
                    String name = (String)nameItr.next();
                    request.addParam(name, json.get(name).toString());
                }
            }
            catch (JSONException e) {
                LOGGER.error("param is error", (Throwable)e);
            }
        }
    }

    private void disableHttpLog() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "stdout,basefile");
    }

    public ResponseInfo execDelete(String url, String param) throws ToolException {
        return this.execDelete(url, param, null);
    }

    public ResponseInfo execDeleteWithNoLog(String url, String param) throws ToolException {
        RestParamEntity entity = new RestParamEntity(false);
        return this.execDelete(url, param, entity);
    }

    public ResponseInfo execDelete(String url, String param, RestParamEntity entity) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        DeleteRequest req = new DeleteRequest(this.replaceHostForSvp(url, this.proxySvpIp));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToRelogin(param, entity, req, resp);
        return resp;
    }

    public ResponseInfo execPost(String url, String param) throws ToolException {
        return this.execPost(url, param, null);
    }

    public ResponseInfo execPostWithNoLog(String url, String param) throws ToolException {
        RestParamEntity entity = new RestParamEntity(false);
        return this.execPost(url, param, entity);
    }

    private void errorCodeCheck(ResponseInfo resp) throws ToolException {
        Long obj = (Long)resp.getContentMap().get("errorCode");
        if (obj == 0L) {
            LOGGER.info("login success.");
            this.isLogined = true;
            this.loginUri = this.uri;
            return;
        }
        this.isLogined = false;
        LOGGER.error("Rest login failed: {}", (Object)obj);
        this.checkIsPwdError(resp);
    }

    private void checkIsPwdError(ResponseInfo resp) throws ToolException {
        if (resp.getContentMap().getOrDefault("description", "").toString().contains(LOGIN_PWD_ERROR)) {
            throw new ToolException("http.authorized.failed");
        }
    }

    public ResponseInfo execPost(String url, String param, RestParamEntity entity) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        PostRequest req = new PostRequest(this.replaceHostForSvp(url, this.proxySvpIp));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToRelogin(param, entity, req, resp);
        return resp;
    }

    private ResponseInfo checkRespToRelogin(String param, RestParamEntity entity, RequestInfo req, ResponseInfo resp) throws ToolException {
        JSONObject json;
        JSONObject jsonData;
        String content = resp.getContent();
        if (content != null && !content.isEmpty() && (jsonData = (json = new JSONObject(content)).getJSONObject("error")) != null && jsonData.getInt("code") == TIMEOUTSTATUSCODE.intValue()) {
            LOGGER.info("Connection timeout and start reconnection.");
            this.reLoginWithTimeOut();
            return this.requestProcess(param, req, entity);
        }
        return resp;
    }

    public void closeSession() {
        if (null != this.session) {
            this.logOut();
            this.session.close();
            this.uri = null;
            this.userName = null;
            this.passW = null;
            this.scope = null;
        }
        if (this.routeMgr != null) {
            try {
                this.routeMgr.close();
            }
            catch (Exception e) {
                LOGGER.error("close route error.");
            }
        }
    }

    private boolean checkLoginResult(ResponseInfo resp) {
        if (resp == null) {
            return false;
        }
        String content = resp.getContent();
        if (content == null || content.isEmpty()) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        JSONObject jsonData = json.getJSONObject("data");
        this.session.setSessionID(this.getJsonValue("iBaseToken", jsonData));
        for (Header h : resp.getHeaders()) {
            String name = h.getName();
            String value = h.getValue();
            if (!name.equals("Set-Cookie")) continue;
            if (value.contains("failLoginCount")) {
                return false;
            }
            if (!value.contains("logFlag=in")) continue;
            return true;
        }
        return content.contains("Your logon site is loading");
    }

    private String getJsonValue(String key, JSONObject jsonObject) {
        if (!jsonObject.has(key)) {
            return "";
        }
        String data = (String)jsonObject.get(key);
        if (StringUtils.isNULLStr((String)data)) {
            return "";
        }
        return data;
    }

    public ResponseInfo execPut(String url, String param) throws ToolException {
        return this.execPut(url, param, null);
    }

    public ResponseInfo execPutWithNoLog(String url, String param) throws ToolException {
        RestParamEntity entity = new RestParamEntity(false);
        return this.execPut(url, param, entity);
    }

    public ResponseInfo execPut(String url, String param, RestParamEntity entity) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        PutRequest req = new PutRequest(this.replaceHostForSvp(url, this.proxySvpIp));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToRelogin(param, entity, req, resp);
        return resp;
    }

    public void logOut() {
        try {
            this.execDelete(this.loginUri, null);
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred on logout.");
        }
        finally {
            this.loginUri = null;
        }
    }

    public String toString() {
        return "RestConnection{scope='" + this.scope + '\'' + ", foradPort=" + this.foradPort + ", proxySvpIp='" + this.proxySvpIp + '\'' + '}';
    }

    public static class RestParamEntity {
        private boolean withLog = true;

        public RestParamEntity(boolean withLog) {
            this.withLog = withLog;
        }

        public boolean isWithLog() {
            return this.withLog;
        }

        public void setWithLog(boolean withLog) {
            this.withLog = withLog;
        }
    }
}

