/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.factory;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.protocol.sftp.SftpProgressInterface;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpConnector.class);
    private SftpTransfer sftpCon = null;
    private DevNode devNode = null;

    public SftpConnector(String ip, int port, String username, String password) {
        this.setLoginInfo(ip, port, username, password);
    }

    public SftpConnector(String ip, int port, String username, String password, String sn) {
        this.setLoginInfo(ip, port, username, password, sn);
    }

    public SftpConnector(DevNode oldDev) {
        this.devNode = oldDev;
    }

    private void setLoginInfo(String ip, int port, String username, String password) {
        DevNode deviceNode = new DevNode();
        User user = new User(username, password, port);
        deviceNode.setLoginUser(user);
        deviceNode.setIp(ip);
        this.devNode = deviceNode;
        this.devNode.setPort(port);
    }

    private void setLoginInfo(String ip, int port, String username, String password, String sn) {
        DevNode deviceNode = new DevNode();
        User user = new User(username, password, port);
        deviceNode.setLoginUser(user);
        deviceNode.setIp(ip);
        deviceNode.setDeviceSerialNumber(sn);
        this.devNode = deviceNode;
        this.devNode.setPort(port);
    }

    public String getLoginInfo() {
        if (null == this.devNode) {
            return null;
        }
        HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put("ip", this.devNode.getIp());
        loginMap.put("port", String.valueOf(this.devNode.getLoginUser().getPort()));
        loginMap.put("user", this.devNode.getLoginUser().getUserName());
        String pwd = this.devNode.getLoginUser().getPassword();
        loginMap.put("pawd", pwd);
        JSONObject json = new JSONObject(loginMap);
        return json.toString();
    }

    public SftpTransfer getConnection() {
        if (null != this.sftpCon) {
            return this.sftpCon;
        }
        this.createSftpConnect(false);
        return this.sftpCon;
    }

    public SftpTransfer getConnectionForPwdWillExpireBreak() {
        if (null != this.sftpCon) {
            return this.sftpCon;
        }
        this.createSftpConnect(true);
        return this.sftpCon;
    }

    private void createSftpConnect(boolean isPwdWillExpireBreak) {
        this.sftpCon = DeviceTypeUtil.hasSVPModule((DevNode)this.devNode) ? new SftpTransfer(isPwdWillExpireBreak) : new SftpTransfer(this.devNode, isPwdWillExpireBreak);
    }

    public void putFile(String localPath, String serverPath, SftpProgressInterface progressListener) throws IsmException {
        this.putFile(localPath, serverPath, progressListener, false);
    }

    public void putFile(String localPath, String serverPath, SftpProgressInterface progressListener, boolean isPwdWillExpireBreak) throws IsmException {
        if (null == this.sftpCon) {
            this.createSftpConnect(isPwdWillExpireBreak);
        }
        try {
            this.sftpCon.putFile(this.devNode.getIp(), localPath, serverPath, this.devNode.getLoginUser(), progressListener);
        }
        catch (IsmException e) {
            LOGGER.error("putFile fialed", (Throwable)e);
            throw e;
        }
    }

    public void getFile(String localPath, String serverPath, SftpProgressInterface progressListener) throws IsmException {
        this.getFile(localPath, serverPath, progressListener, false);
    }

    public void getFile(String localPath, String serverPath, SftpProgressInterface progressListener, boolean isPwdWillExpireBreak) throws IsmException {
        File localFile;
        if (null == this.sftpCon) {
            this.createSftpConnect(isPwdWillExpireBreak);
        }
        if (!(localFile = new File(localPath)).exists() && !localFile.mkdirs()) {
            LOGGER.error("localFile mkdirs err.");
        }
        try {
            this.sftpCon.getFile(this.devNode.getIp(), localPath, serverPath, this.devNode.getLoginUser(), progressListener);
        }
        catch (IsmException e) {
            LOGGER.error("getFile fialed", (Throwable)e);
            throw e;
        }
    }

    public void deleteFile(String serverPath) throws IsmException, ToolException {
        try {
            this.sftpCon.deleteFile(this.devNode.getIp(), this.devNode.getLoginUser(), new String[]{serverPath});
        }
        catch (IsmException | ToolException e) {
            LOGGER.error("delete File failed", e);
            throw e;
        }
    }
}

