/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.item.Item;
import com.huawei.ism.tool.bizpack.wizardparse.task.DoItemsTask;
import com.huawei.ism.tool.bizpack.wizardparse.task.TaskManager;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.DoItemsUiObserver;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStep;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoItemStep.class);
    private static final int TIME_BLANK_SIZE = 150;
    private static final int WIZARD_BLANK_SIZE = 70;
    private static final Color GREEN = new Color(4423169);
    private LoadItemLayout layout = null;
    private boolean finish = false;
    private String scriptPath = "";
    private String initScript = "";
    private JythonContext ssenv = null;
    private String name = "";
    private String title = "";
    private ICallback callBack;
    private ItemUiObserver uiObserver = new ItemUiObserver();
    private PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();

    public LoadItem(String name, String desc, String script) {
        this.name = name;
        this.title = desc;
        this.initScript = script;
    }

    public void init(JythonContext env, String scriptpath, ICallback callback) {
        this.ssenv = env;
        this.scriptPath = scriptpath;
        this.callBack = callback;
        this.executeScript();
    }

    public void initListener() {
        this.layout.getRetryBtn().removeAll();
        this.layout.getRetryBtn().addActionListener(e -> {
            LOGGER.info("user click retry {} button", (Object)this.layout.getRetryBtn().getText());
            this.executeScript();
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the lister length= {}", (Object)this.layout.getRetryBtn().getActionListeners().length);
        }
    }

    private void executeScript() {
        this.finish = false;
        this.ssenv.getDict().put("remainTime", null);
        this.ssenv.getDict().put("curProgressPer", null);
        ArrayList<Item> items = new ArrayList<Item>();
        Item item = new Item();
        item.setScriptName(this.initScript);
        item.setTitle(this.title);
        item.setDesc("");
        items.add(item);
        DoItemsTask itemTask = new DoItemsTask(items, this.uiObserver, this.scriptPath, 0);
        if (!TaskManager.submitTask(itemTask, this.title)) {
            LOGGER.warn("sumit item {} fail", (Object)this.initScript);
            return;
        }
        this.layout.getRetryBtn().setEnabled(false);
        this.layout.setStatusPanelEnable(true, true);
        this.layout.resultPanel.setVisible(false);
        this.layout.resultPanel.removeAll();
        this.layout.setCurrentProgress("");
        this.callBack.init();
        new QueryProgressTask().start();
        new QueryRemainTimeTask().start();
    }

    public LoadItemLayout getLayout() {
        if (null == this.layout) {
            this.layout = new LoadItemLayout();
            this.initListener();
        }
        return this.layout;
    }

    static /* synthetic */ String access$600(LoadItem x0) {
        return x0.name;
    }

    public static interface ICallback {
        public void init();

        public void finish(boolean var1, String var2);
    }

    public class ItemUiObserver
    implements DoItemsUiObserver {
        @Override
        public void fireFinish(Item item, int curIndex) {
            LOGGER.info("enter fireFinish.");
            if (((Boolean)LoadItem.this.ssenv.getDict().get("succ")).booleanValue()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("succ......" + curIndex);
                }
                this.setCurrentStatusTxt(item.getTitleRes(LoadItem.this.resource) + ResourceUtil.getStringWithParams("expansion.wizard.doitem.finish", " "));
            } else {
                LoadItem.this.finish = true;
                ArrayList<String> msgs = new ArrayList<String>();
                msgs.add("failed");
                msgs.add((String)LoadItem.this.ssenv.getDict().get("errMsg"));
                msgs.add((String)LoadItem.this.ssenv.getDict().get("suggestion"));
                LoadItem.this.layout.getRetryBtn().setEnabled(true);
                LoadItem.this.layout.setStatusPanelEnable(false, false);
                this.setCurrentStatusTxt(LoadItem.this.resource.getString(item.getTitle()) + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
                String errMsg = LoadItem.this.layout.showResultInfo(msgs);
                LoadItem.this.callBack.finish(false, errMsg);
            }
        }

        @Override
        public void fireAllFinish() {
            LOGGER.info("enter fireAllFinish.");
            LoadItem.this.finish = true;
            LoadItem.this.layout.setStatusPanelEnable(false, false);
            LoadItem.this.callBack.finish(true, "");
            LoadItem.this.layout.getRetryBtn().setEnabled(true);
        }

        @Override
        public void refreshItemLoading(Item item, int curIndex) {
            LOGGER.info("enter refreshItemLoading.");
        }

        @Override
        public void setCurrentStatusTxt(String txt) {
            LoadItem.this.layout.setCurrentStatusTxt(txt);
        }

        @Override
        public void setCurrentStatusIcon(ImageIcon icon) {
            LoadItem.this.layout.currentStatusTxt.setIcon(icon);
        }

        @Override
        public void setCurrentDescTxt(String txt) {
            LOGGER.info("enter setCurrentDescTxt.");
        }

        @Override
        public void fireException(Exception e, Item item, int curIndex) {
            LOGGER.info("enter fireException.");
            LoadItem.this.finish = true;
            ArrayList<String> msgs = new ArrayList<String>();
            msgs.add("failed");
            if (e instanceof FileNotFoundException) {
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound"));
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptfilenotfound.suggestion"));
            } else if (e instanceof SignException) {
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned"));
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptfile.notsigned.suggestion"));
            } else {
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr"));
                msgs.add(ResourceUtil.getString("bizpackage.error.doitem.scriptexecerr.suggestion"));
            }
            String errMsg = LoadItem.this.layout.showResultInfo(msgs);
            LoadItem.this.layout.getRetryBtn().setEnabled(true);
            LoadItem.this.layout.setStatusPanelEnable(false, false);
            LoadItem.this.layout.setCurrentStatusTxt(item.getTitleRes(LoadItem.this.resource) + ResourceUtil.getStringWithParams("expansion.wizard.doitem.failed", " "));
            LoadItem.this.callBack.finish(false, errMsg);
        }
    }

    public class LoadItemLayout
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final int EXTEND_WEIGHT = 44;
        private static final int JLABEL_HEIGHT = 550;
        private static final int WARNING_HEIGHT = 34;
        private static final int BORDER_SIZE = 20;
        private static final String MARK_SIGN_REG_EXP = "([\\w|\\s]*)([\ufe30-\uffa0\u2018\u2019\u201c\u201d,\\.;\\:\"'!])(.*)";
        private static final String ICON_TYPE = ".gif";
        private Font suggestFont = new Font("", 1, 12);
        private JLabel currentStatusTxt = new JLabel();
        private JLabel currentDesc = new JLabel();
        private JLabel currentLeftTimeDes = new JLabel();
        JPanel resultPanel = new JPanel();
        private JLabel currentLeftTime = new JLabel();
        private PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        private JButton retryBtn = UiMethod.createButton((String)this.resource.getString(LoadItem.access$600(LoadItem.this)), (char)'R');
        private JLabel currentResultTxt = new JLabel();
        private JLabel currentResultSuggustion = new JLabel();
        private JLabel currentProgress = new JLabel();

        public LoadItemLayout() {
            this.initUI(true, true);
        }

        private void initUI(boolean showPro, boolean showLeftTime) {
            this.currentProgress.setFont(new Font(this.getName(), 150, 20));
            this.currentProgress.setForeground(GREEN);
            this.currentProgress.setPreferredSize(new Dimension(70, 25));
            this.currentLeftTime.setFont(new Font(this.getName(), 150, 22));
            this.currentLeftTime.setForeground(GREEN);
            JPanel leftTimePanel = new JPanel();
            leftTimePanel.setLayout(new GridLayout(2, 1));
            leftTimePanel.add(this.currentLeftTimeDes);
            leftTimePanel.add(this.currentLeftTime);
            JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildVerticalOppositionalPan((Component)UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.retryBtn, Box.createHorizontalStrut(5), this.currentStatusTxt, this.currentProgress}), (Component)this.currentDesc), leftTimePanel});
            this.setStatusPanelEnable(showPro, showLeftTime);
            this.setLayout(new BorderLayout());
            Dimension wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
            this.resultPanel.setPreferredSize(new Dimension(wizardSize.width - 44, (int)((double)wizardSize.height * 0.3)));
            this.resultPanel.setVisible(false);
            this.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{view, this.resultPanel}), "North");
        }

        public JButton getRetryBtn() {
            return this.retryBtn;
        }

        public void setCurrentStatusTxt(String txt) {
            this.currentStatusTxt.setText(txt);
        }

        public void setCurrentProgress(int progress, boolean isshow) {
            String progressPer = progress + "%";
            this.getCurrentProgress().setVisible(isshow);
            this.setCurrentProgress(progressPer);
        }

        public void setCurrentRemainTime(int remainTime, boolean isshow) {
            int seconds = remainTime % 60;
            int minutes = remainTime / 60;
            String remainTimeFinal = this.getTime(minutes, seconds);
            this.currentLeftTimeDes.setVisible(isshow);
            this.currentLeftTime.setVisible(isshow);
            this.currentLeftTimeDes.setText(ResourceUtil.getString("wizard.doitem.desc.timeleft"));
            this.currentLeftTime.setText(remainTimeFinal);
        }

        private String getTime(int minutes, int seconds) {
            SimpleDateFormat fo = new SimpleDateFormat("HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, minutes);
            cal.set(13, seconds);
            return fo.format(cal.getTime());
        }

        public String showResultInfo(List<String> msgs) {
            int maxWidth = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize().width - 70;
            int maxHeight = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize().height - 550;
            this.currentResultTxt.setFont(this.suggestFont);
            String resultIcon = msgs.get(0);
            this.currentResultTxt.setIcon(ResourceUtil.getImage(resultIcon + ICON_TYPE));
            this.handleMsgDisplay(msgs);
            this.currentResultTxt.setPreferredSize(new Dimension(maxWidth, 34));
            this.currentResultSuggustion.setText(msgs.get(2));
            this.currentResultSuggustion.setForeground(Color.black);
            this.currentResultSuggustion = this.createJLabelWithWrapWidth((int)((double)maxWidth * 0.8), (int)((double)maxHeight * 0.8), this.currentResultSuggustion);
            this.resultPanel.removeAll();
            this.resultPanel.setSize(maxWidth, maxHeight);
            this.resultPanel.setLayout(new GridBagLayout());
            GridBagConstraints con = new GridBagConstraints();
            con.fill = 0;
            con.anchor = 18;
            con.gridx = 0;
            con.gridy = 0;
            con.weightx = 0.0;
            con.weighty = 0.0;
            con.insets = new Insets(0, 0, 0, 0);
            this.resultPanel.add((Component)this.currentResultTxt, con);
            con.insets = new Insets(5, 20, 0, 0);
            ++con.gridy;
            con.weightx = 1.0;
            con.weighty = 1.0;
            this.resultPanel.add((Component)this.currentResultSuggustion, con);
            String suggestion = this.currentResultSuggustion.getText().replaceAll("<br>", "\n");
            this.resultPanel.setVisible(true);
            return this.currentResultTxt.getText() + System.lineSeparator() + suggestion;
        }

        public JLabel createJLabelWithWrapWidth(int width, int hight, JLabel label) {
            if (width <= 0 || label == null) {
                return label;
            }
            String text = label.getText();
            if (!text.startsWith("<html>")) {
                StringBuilder strBuilder = new StringBuilder("<html><body style=\"word-wrap:break-word;word-break:break-all;\" width='" + (width - 20) + "px' hight='" + (hight - 20) + "px'>");
                strBuilder.append(text);
                strBuilder.append("</body></html>");
                text = strBuilder.toString();
            }
            label.setText(text);
            return label;
        }

        private void handleMsgDisplay(List<String> msgs) {
            Pattern markPtn = Pattern.compile(MARK_SIGN_REG_EXP, 66);
            String msgTitle = msgs.get(1);
            try {
                Matcher mat = markPtn.matcher(msgTitle);
                if (msgTitle.length() > 40 && mat.find()) {
                    int startIdx = msgTitle.indexOf(mat.group(2));
                    String errTitle = msgTitle.substring(0, startIdx) + "...";
                    this.setLabelText(this.currentResultTxt, errTitle);
                    this.resultPanel.setToolTipText(UCD.wrapTextWithHTML((FontMetrics)this.getFontMetrics(this.currentResultTxt.getFont()), (String)msgTitle, (int)300));
                } else {
                    this.setLabelText(this.currentResultTxt, msgTitle);
                }
            }
            catch (Throwable t) {
                this.setLabelText(this.currentResultTxt, msgTitle);
            }
        }

        private void setLabelText(JLabel label, String text) {
            label.setText(text);
            label.setForeground(Color.black);
        }

        public void setStatusPanelEnable(boolean showPro, boolean showLeftTime) {
            if (!showPro) {
                this.currentProgress.setEnabled(false);
                this.currentProgress.setVisible(false);
            } else {
                this.currentProgress.setEnabled(true);
                this.currentProgress.setVisible(true);
            }
            if (!showLeftTime) {
                this.currentLeftTime.setEnabled(false);
                this.currentLeftTime.setVisible(false);
                this.currentLeftTimeDes.setEnabled(false);
                this.currentLeftTimeDes.setVisible(false);
            } else {
                this.currentLeftTime.setEnabled(true);
                this.currentLeftTime.setVisible(true);
                this.currentLeftTimeDes.setEnabled(true);
                this.currentLeftTimeDes.setVisible(true);
            }
        }

        public JLabel getCurrentProgress() {
            return this.currentProgress;
        }

        public void setCurrentProgress(String currentProgress) {
            this.currentProgress.setText(currentProgress);
        }
    }

    private class QueryRemainTimeTask
    extends Thread {
        private QueryRemainTimeTask() {
        }

        @Override
        public void run() {
            String id = "timeTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryRemainTimeTask id[" + id + "] start");
            }
            while (LoadItem.this.ssenv.getDict().get("remainTime") != null || !LoadItem.this.finish) {
                if (LoadItem.this.ssenv.getDict().get("remainTime") == null) {
                    LoadItem.this.layout.setCurrentRemainTime(0, false);
                    continue;
                }
                int remainTime = (Integer)LoadItem.this.ssenv.getDict().get("remainTime");
                LoadItem.this.layout.setCurrentRemainTime(remainTime, true);
                if (LoadItem.this.finish) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("queryRemainTimeTask id[" + id + "] end");
                    }
                    LoadItem.this.layout.setCurrentRemainTime(0, false);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }

    private class QueryProgressTask
    extends Thread {
        private QueryProgressTask() {
        }

        @Override
        public void run() {
            String id = "progressTask_" + new Date().getTime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("queryProgressTask id[" + id + "] start");
            }
            while (LoadItem.this.ssenv.getDict().get("curProgressPer") != null || !LoadItem.this.finish) {
                if (LoadItem.this.ssenv.getDict().get("curProgressPer") == null) {
                    LoadItem.this.layout.setCurrentProgress(0, false);
                    continue;
                }
                int progress = (Integer)LoadItem.this.ssenv.getDict().get("curProgressPer");
                LoadItem.this.layout.setCurrentProgress(progress, true);
                if (LoadItem.this.finish) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("queryProgressTask id[" + id + "] end");
                    }
                    if (progress == 0) {
                        LoadItem.this.layout.setCurrentProgress(0, false);
                        break;
                    }
                    if (progress <= 0 || progress >= 100) break;
                    LoadItem.this.layout.setCurrentProgress(100, true);
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("setCurrentProgress sleep err", (Throwable)e);
                }
            }
        }
    }
}

