/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.TableDetailInfoDialogLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.CompileAndExecOnePyFuncWaitDialog;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class TableDetailInfoDialog
extends JDialog {
    private static final long serialVersionUID = -1968028508783628699L;
    private static final String METHOD = "retDialogData";
    private String script = "";
    private String scriptPath;
    private String param = "";
    private TableDetailInfoDialogLayout layout;
    private transient TableItem table;

    public TableDetailInfoDialog(TableColumn data, String scriptPath, Window parent) {
        super(parent);
        this.setModal(true);
        this.setResizable(false);
        this.layout = new TableDetailInfoDialogLayout(data);
        this.table = data.getDetailDialogTable();
        this.script = data.getScript();
        this.param = data.getParam();
        this.scriptPath = scriptPath;
        this.setTable();
        this.initListener();
        UiMethod.setComponentSize((Dimension)data.getDialogSize(), (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
        this.setTitle(ResourceUtil.getString("bizpack.wizard.stopiostep.detail"));
        this.add(this.layout);
    }

    private void initListener() {
        this.setDefaultCloseOperation(2);
        this.layout.getCloseBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDetailInfoDialog.this.confirmeAction();
            }
        });
    }

    private void confirmeAction() {
        this.dispose();
    }

    private void setTable() {
        this.execFunc();
    }

    private void execFunc() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizPackageContext.getInstance().getJythonContext().clearMsgData();
                List fs = AsyncExcutor.execute((Window)TableDetailInfoDialog.this, (Callable[])new Callable[]{new CompileAndExecOnePyFuncWaitDialog(TableDetailInfoDialog.this.scriptPath, TableDetailInfoDialog.this.script, TableDetailInfoDialog.METHOD, TableDetailInfoDialog.this.param)});
                WaitDialogResult result = (WaitDialogResult)fs.get(0);
                if (!WaitDialogResult.handleResult(TableDetailInfoDialog.this, result)) {
                    return;
                }
                ExecPyScriptTask task = result.getTask();
                if (null == task) {
                    DialogUtils.showErrorDialog((JDialog)TableDetailInfoDialog.this, (String)ResourceUtil.getString("bizpackage.error.preset.scriptinitfailed"));
                    return;
                }
                TableDetailInfoDialog.this.initTableData();
            }
        });
    }

    private void initTableData() {
        Map<String, Object> dict = BizPackageContext.getInstance().getJythonContext().getDict();
        this.table.getTableModel().removeAll();
        String json = (String)dict.get("retData");
        this.table.setJsonRetData(json);
        this.table.initFresh();
    }
}

