/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileOnePyWaitDialog
implements Callable<WaitDialogResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileOnePyWaitDialog.class);
    private String preScriptPath = "";
    private String pyName = "";

    public CompileOnePyWaitDialog(String preScriptPath, String pyName) {
        this.preScriptPath = preScriptPath;
        this.pyName = pyName;
    }

    @Override
    public WaitDialogResult call() {
        WaitDialogResult result = new WaitDialogResult();
        ExecPyScriptTask preSetTask = null;
        try {
            preSetTask = new ExecPyScriptTask(this.preScriptPath, this.pyName);
            result.setFlag(true);
            result.setTask(preSetTask);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("CompileOnePy jython File {} not found", (Object)this.pyName);
            result.setFlag(false);
            result.setException(new FileNotFoundException());
        }
        catch (SignException e) {
            LOGGER.error("CompileOnePy python file has no sign", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        catch (Exception e) {
            LOGGER.error("CompileOnePy jython exec err", (Throwable)e);
            result.setFlag(false);
            result.setException(e);
        }
        return result;
    }
}

