/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.parameterization.support;

import com.huawei.fitframework.core.common.parameterization.ParameterizedString;
import com.huawei.fitframework.core.common.parameterization.ParameterizedStringResolver;
import com.huawei.fitframework.core.common.parameterization.support.DefaultParameterizedString;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;

public class DefaultParameterizedStringResolver
implements ParameterizedStringResolver {
    private final String prefix;
    private final String suffix;
    private final char escapeCharacter;

    public DefaultParameterizedStringResolver(String prefix, String suffix, char escapeCharacter) {
        Validation.notBlank(prefix, "The prefix to resolve variables cannot be null or empty.", new Object[0]);
        Validation.notBlank(suffix, "The suffix to resolve variables cannot be null or empty.", new Object[0]);
        DefaultParameterizedStringResolver.validateXFixEscapeCharacter(prefix, escapeCharacter, "The prefix cannot contains the escape character. [prefix={0}, escape={1}, position={2}]");
        DefaultParameterizedStringResolver.validateXFixEscapeCharacter(suffix, escapeCharacter, "The suffix cannot contains the escape character. [suffix={0}, escape={1}, position={2}]");
        this.prefix = prefix;
        this.suffix = suffix;
        this.escapeCharacter = escapeCharacter;
    }

    private static void validateXFixEscapeCharacter(String xFix, char escapeCharacter, String errorFormat) {
        int index = xFix.indexOf(escapeCharacter);
        if (index >= 0) {
            throw new IllegalArgumentException(StringUtils.format(errorFormat, xFix, Character.valueOf(escapeCharacter), index));
        }
    }

    @Override
    public String getParameterPrefix() {
        return this.prefix;
    }

    @Override
    public String getParameterSuffix() {
        return this.suffix;
    }

    @Override
    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    @Override
    public ParameterizedString resolve(String originalString) {
        Validation.notNull(originalString, "The string to resolve as a parameterized string cannot be null.", new Object[0]);
        return DefaultParameterizedString.resolve(this, originalString);
    }
}

