/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.type.support;

import com.huawei.fitframework.core.common.type.TypeMatcher;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public abstract class AbstractTypeMatcher<C extends Type, E extends Type>
implements TypeMatcher {
    private final C currentType;
    private final TypeMatcher.Context context;

    public AbstractTypeMatcher(C currentType, TypeMatcher.Context context) {
        this.currentType = (Type)Validation.notNull(currentType, "The object type to match cannot be null.", new Object[0]);
        this.context = Validation.notNull(context, "The context to match cannot be null.", new Object[0]);
    }

    @Override
    public boolean match(Type expectedType) {
        return this.match0(expectedType);
    }

    protected abstract boolean match0(E var1);

    protected List<Type> listSuperTypes(Class<?> clazz) {
        Type[] interfaces = clazz.getGenericInterfaces();
        Type superClass = clazz.getGenericSuperclass();
        if (superClass == null) {
            return Arrays.asList(interfaces);
        }
        ArrayList<Type> superTypes = new ArrayList<Type>(interfaces.length + 1);
        superTypes.addAll(Arrays.asList(interfaces));
        superTypes.add(superClass);
        return superTypes;
    }

    protected boolean matchSuperTypes(Class<?> clazz, Type expectedType) {
        TypeMatcher.Context superContext = this.getSuperContext();
        return this.listSuperTypes(clazz).stream().anyMatch(superType -> TypeMatcher.match(superType, expectedType, superContext));
    }

    protected TypeMatcher.Context getSuperContext() {
        return this.getContext();
    }

    @Generated
    public C getCurrentType() {
        return this.currentType;
    }

    @Generated
    public TypeMatcher.Context getContext() {
        return this.context;
    }
}

