/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class Convert {
    private Convert() {
    }

    public static <T, R> R convert(T value, Function<T, R> mapper) {
        Validation.notNull(mapper, "The mapper to convert object cannot be null.", new Object[0]);
        if (value == null) {
            return null;
        }
        return mapper.apply(value);
    }

    public static <T, R> List<R> convert(List<T> values, Function<T, R> mapper) {
        return Convert.convert(values, mapper, null);
    }

    public static <T, R> List<R> convert(List<T> values, Function<T, R> mapper, IntFunction<List<R>> listFactory) {
        List results;
        Validation.notNull(mapper, "The mapper to convert object cannot be null.", new Object[0]);
        if (values == null) {
            results = null;
        } else {
            results = ObjectUtils.nullIf(listFactory, ArrayList::new).apply(values.size());
            for (T value : values) {
                results.add(Convert.convert(value, mapper));
            }
        }
        return results;
    }

    public static byte[] toBytes(byte value) {
        return new byte[]{value};
    }

    public static byte toByte(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert byte cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 1, "Length of bytes to convert byte cannot be greater than 1.", new Object[0]);
        return bytes.length > 0 ? bytes[0] : (byte)0;
    }

    public static byte[] toBytes(short value) {
        return new byte[]{Convert.byteValue(value >>> 8), Convert.byteValue(value)};
    }

    public static short toShort(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert short cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 2, "Length of bytes to convert short cannot be greater than 2.", new Object[0]);
        int value = Convert.toInteger(bytes);
        return (short)value;
    }

    public static byte[] toBytes(int value) {
        return new byte[]{Convert.byteValue(value >>> 24), Convert.byteValue(value >>> 16), Convert.byteValue(value >>> 8), Convert.byteValue(value)};
    }

    public static int toInteger(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert integer cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 4, "Length of bytes to convert integer cannot be greater than 4.", new Object[0]);
        int value = 0;
        for (byte aByte : bytes) {
            value = value << 8 | Byte.toUnsignedInt(aByte);
        }
        return value;
    }

    public static byte[] toBytes(long value) {
        return new byte[]{Convert.byteValue(value >>> 56), Convert.byteValue(value >>> 48), Convert.byteValue(value >>> 40), Convert.byteValue(value >>> 32), Convert.byteValue(value >>> 24), Convert.byteValue(value >>> 16), Convert.byteValue(value >>> 8), Convert.byteValue(value)};
    }

    public static long toLong(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert long cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 8, "Length of bytes to convert long cannot be greater than 8.", new Object[0]);
        long value = 0L;
        for (byte aByte : bytes) {
            value = value << 8 | Byte.toUnsignedLong(aByte);
        }
        return value;
    }

    public static byte[] toBytes(float value) {
        return Convert.toBytes(Float.floatToIntBits(value));
    }

    public static float toFloat(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert float cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 4, "Length of bytes to convert float cannot be greater than 4.", new Object[0]);
        return Float.intBitsToFloat(Convert.toInteger(bytes));
    }

    public static byte[] toBytes(double value) {
        return Convert.toBytes(Double.doubleToLongBits(value));
    }

    public static double toDouble(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert double cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 8, "Length of bytes to convert double cannot be greater than 8.", new Object[0]);
        return Double.longBitsToDouble(Convert.toLong(bytes));
    }

    public static byte[] toBytes(char value) {
        return Convert.toBytes((short)value);
    }

    public static char toCharacter(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert character cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 2, "Length of bytes to convert character cannot be greater than 2.", new Object[0]);
        return (char)Convert.toInteger(bytes);
    }

    public static byte[] toBytes(boolean value) {
        return Convert.toBytes((byte)(value ? 1 : 0));
    }

    public static boolean toBoolean(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert boolean cannot be null.", new Object[0]);
        Validation.lessThanOrEquals(bytes.length, 1, "Length of bytes to convert boolean cannot be greater than 1.", new Object[0]);
        return Convert.toByte(bytes) != 0;
    }

    public static byte[] toBytes(String value) {
        return ObjectUtils.nullIf(value, "").getBytes(StandardCharsets.UTF_8);
    }

    public static String toString(byte[] bytes) {
        Validation.notNull(bytes, "The bytes to convert String cannot be null.", new Object[0]);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte byteValue(int value) {
        return (byte)(value & 0xFF);
    }

    private static byte byteValue(long value) {
        return (byte)(value & 0xFFL);
    }
}

