/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.DateUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ValueConverter {
    private static final Map<Class<?>, Function<String, Object>> PARSERS = new HashMap();

    private ValueConverter() {
    }

    public static Object convert(String source, Class<?> targetClass) {
        Validation.notNull(targetClass, "Target class to convert to cannot be null.", new Object[0]);
        if (source == null) {
            return null;
        }
        Class<?> actualTargetClass = ReflectionUtils.ignorePrimitiveClass(targetClass);
        Function<String, Object> parser = PARSERS.get(actualTargetClass);
        Validation.notNull(parser, () -> new ClassCastException(StringUtils.format("Not supported class to resolve configuration. [targetClass={0}]", targetClass.getSimpleName())));
        return parser.apply(source);
    }

    private static <T> T tryParse(String source, Function<String, T> mapper) {
        String actual = StringUtils.trim(source);
        if (StringUtils.isBlank(actual)) {
            return null;
        }
        try {
            return mapper.apply(actual);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        PARSERS.put(Byte.class, str -> ValueConverter.tryParse(str, Byte::parseByte));
        PARSERS.put(Short.class, str -> ValueConverter.tryParse(str, Short::parseShort));
        PARSERS.put(Integer.class, str -> ValueConverter.tryParse(str, Integer::parseInt));
        PARSERS.put(Long.class, str -> ValueConverter.tryParse(str, Long::parseLong));
        PARSERS.put(Float.class, str -> ValueConverter.tryParse(str, Float::parseFloat));
        PARSERS.put(Double.class, str -> ValueConverter.tryParse(str, Double::parseDouble));
        PARSERS.put(Character.class, str -> {
            String actual = StringUtils.trim(str);
            if (actual.length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            return null;
        });
        PARSERS.put(Boolean.class, str -> {
            String actual = StringUtils.trim(str);
            if (StringUtils.equalsIgnoreCase(actual, "true")) {
                return true;
            }
            if (StringUtils.equalsIgnoreCase(actual, "false")) {
                return false;
            }
            return null;
        });
        PARSERS.put(Date.class, str -> ValueConverter.tryParse(str, DateUtils::parse));
        PARSERS.put(String.class, str -> str);
    }
}

