/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.CertPath;
import com.huawei.cms.verify.bc.CertWrapper;
import com.huawei.cms.verify.bc.CmsValidationException;
import com.huawei.cms.verify.bc.CmscbbErr;
import com.huawei.cms.verify.bc.CrlWrapper;
import com.huawei.cms.verify.bc.InternalCmscbbConf;
import com.huawei.cms.verify.bc.ValidationResult;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.AnnotatedException;

public class PkiValidator {
    private static final List<ASN1ObjectIdentifier> KNOWN_EXTN_TYPES = Arrays.asList(Extension.authorityInfoAccess, Extension.authorityKeyIdentifier, Extension.basicConstraints, Extension.certificatePolicies, Extension.cRLDistributionPoints, Extension.extendedKeyUsage, Extension.keyUsage, Extension.subjectKeyIdentifier, Extension.subjectAlternativeName);
    private static final int NEW_VERIFIED_CERTS_IND = 0;
    private static final int UNTRUSTED_CERTS_IND = 1;
    private final InternalCmscbbConf conf;
    private Date verificationTime = null;

    public PkiValidator(InternalCmscbbConf conf) {
        this.conf = conf;
    }

    public void setVerificationTime(Date verificationTime) {
        this.verificationTime = (Date)verificationTime.clone();
    }

    private List<CertWrapper> extractTrustedCaOrCrlIssuers() {
        List<List<CertWrapper>> certsList;
        List<CertWrapper> newVerifiedCerts;
        List<CertWrapper> trustAnchors;
        List<CertWrapper> remainingCerts = this.getRemainCerts();
        List<CertWrapper> caCerts = trustAnchors = this.conf.getTrustAnchors(this.verificationTime);
        LinkedList<CertWrapper> verifiedCaCerts = new LinkedList<CertWrapper>();
        while (!(newVerifiedCerts = (certsList = this.getCertsList(caCerts, remainingCerts, trustAnchors)).get(0)).isEmpty()) {
            caCerts = newVerifiedCerts;
            verifiedCaCerts.addAll(newVerifiedCerts);
            remainingCerts.removeAll(newVerifiedCerts);
            remainingCerts.removeAll((Collection)certsList.get(1));
            if (!remainingCerts.isEmpty()) continue;
        }
        return verifiedCaCerts;
    }

    private List<CertWrapper> getRemainCerts() {
        LinkedList<CertWrapper> remainingCerts = new LinkedList<CertWrapper>();
        for (CertWrapper cert : this.conf.getCertWrappers()) {
            boolean include = cert.hasUsages(4) || cert.hasUsages(2);
            if (!(include = include && cert.isValidOn(this.verificationTime))) continue;
            remainingCerts.add(cert);
        }
        return remainingCerts;
    }

    private List<List<CertWrapper>> getCertsList(List<CertWrapper> cas, List<CertWrapper> remainingCerts, List<CertWrapper> trustAnchors) {
        LinkedList<CertWrapper> newVerifiedCerts = new LinkedList<CertWrapper>();
        LinkedList<CertWrapper> untrustedCerts = new LinkedList<CertWrapper>();
        for (CertWrapper ca : cas) {
            if (!ca.isCA()) continue;
            this.updateCertLists(remainingCerts, trustAnchors, newVerifiedCerts, untrustedCerts, ca);
        }
        ArrayList<List<CertWrapper>> certsList = new ArrayList<List<CertWrapper>>();
        certsList.add(0, newVerifiedCerts);
        certsList.add(1, untrustedCerts);
        return certsList;
    }

    private void updateCertLists(List<CertWrapper> remainingCerts, List<CertWrapper> trustAnchors, List<CertWrapper> newVerifiedCerts, List<CertWrapper> untrustedCerts, CertWrapper ca) {
        for (CertWrapper cert : remainingCerts) {
            if (!ca.isCertIssuer(cert)) continue;
            cert.setSigVerification(null);
            cert.setIssuerCert(ca);
            CmscbbErr err = this.checkCertVaild(cert, trustAnchors, ca);
            if (err == CmscbbErr.OK) {
                cert.setSigVerification(CmscbbErr.OK);
                newVerifiedCerts.add(cert);
                continue;
            }
            cert.setSigVerification(err);
            untrustedCerts.add(cert);
        }
    }

    private CmscbbErr checkCertVaild(CertWrapper cert, List<CertWrapper> trustAnchors, CertWrapper ca) {
        CmscbbErr err = this.getCheckCertTimeErr(cert, trustAnchors);
        if (err != CmscbbErr.OK) {
            return err;
        }
        if (!this.checkCriticalExtend(cert.getCert().getCriticalExtensionOIDs())) {
            return CmscbbErr.PKI_CERT_UNKNOWN_CRITICAL_EXTNS;
        }
        if (!this.conf.getAlgorithmValidator().allowsAlgorithm(cert.getCertSignAlgo())) {
            return CmscbbErr.PKI_CERT_SIG_ALGO;
        }
        if (!ca.verifySignature(cert)) {
            return CmscbbErr.PKI_CERT_VERIFY_FAILED;
        }
        return err;
    }

    private CmscbbErr getCheckCertTimeErr(CertWrapper cert, List<CertWrapper> trustAnchors) {
        if (!cert.isLinkCert() && !trustAnchors.contains(cert)) {
            if (cert.getNotBefore().after(this.verificationTime)) {
                return CmscbbErr.PKI_CERT_DATETIME_NO_VALID_YET;
            }
            if (cert.getNotAfter().before(this.verificationTime)) {
                return CmscbbErr.PKI_CERT_DATETIME_EXPIRED;
            }
        }
        return CmscbbErr.OK;
    }

    private boolean checkCriticalExtend(Set<?> extTypes) {
        for (Object obj : extTypes) {
            if (KNOWN_EXTN_TYPES.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public void checkTrustOfSignerCert(ValidationResult result, boolean timestamp, CertWrapper targetCert, List<CrlWrapper> crls) throws GeneralSecurityException, AnnotatedException {
        CmscbbErr err = this.verifyPrepare(targetCert);
        if (err != CmscbbErr.OK) {
            result.setErrorCode(err);
            return;
        }
        List<CertWrapper> caOrCrlIssuers = this.extractTrustedCaOrCrlIssuers();
        CertPath certPath = this.buildCertPath(targetCert, caOrCrlIssuers);
        List<CertPath> certPaths = this.generateCertPaths(certPath);
        try {
            for (CertPath path : certPaths) {
                this.validateCert(path, caOrCrlIssuers, crls, new AtomicInteger(0), timestamp);
            }
        }
        catch (CmsValidationException e) {
            throw new CertPathBuilderException(e.getErrorCode().toString());
        }
    }

    private CmscbbErr verifyPrepare(CertWrapper targetCert) throws AnnotatedException {
        if (this.verificationTime == null) {
            throw new AnnotatedException("verificationTime is null");
        }
        if (this.isErr(targetCert.getSigVerification())) {
            return CmscbbErr.PKI_CERT_VERIFY_FAILED;
        }
        if (this.isErr(targetCert.getStatusVerification())) {
            return CmscbbErr.PKI_CERT_VERIFY_FAILED;
        }
        if (!targetCert.isValidOn(this.verificationTime)) {
            return CmscbbErr.PKI_CERT_DATETIME_EXPIRED;
        }
        return CmscbbErr.OK;
    }

    private boolean isErr(CmscbbErr err) {
        return err != null && err != CmscbbErr.OK;
    }

    private List<CertPath> generateCertPaths(CertPath certPath) {
        CertPath cp;
        LinkedList<CertPath> certpaths = new LinkedList<CertPath>();
        certpaths.add(certPath);
        while (!(cp = ((CertPath)certpaths.get(0)).certPathOfIssuer()).getTargetIsTrustAnchor()) {
            certpaths.add(0, cp);
        }
        return certpaths;
    }

    private void validateCrl(CrlWrapper crl, List<CertWrapper> caOrCrlIssuers, List<CrlWrapper> crls, AtomicInteger level, boolean timestamp) throws CmsValidationException, GeneralSecurityException, AnnotatedException {
        this.checkLevel(level);
        CertWrapper crlIssuer = this.getCrlIssuer(crl, caOrCrlIssuers);
        CertPath crlIssuerCertPath = this.buildCertPath(crlIssuer, caOrCrlIssuers);
        if (this.crlHasValidated(crl, crlIssuerCertPath)) {
            return;
        }
        crl.setIssuerCertPath(crlIssuerCertPath);
        if (this.conf.isContainsTrustAnchor(crlIssuer)) {
            crl.setVerified(Boolean.TRUE);
            return;
        }
        level.incrementAndGet();
        boolean crlIssuerIsCoveredByCrl = crl.isCandidateForCert(crlIssuer);
        try {
            if (crlIssuerIsCoveredByCrl) {
                this.validateCertPathOfIssuer(crl, caOrCrlIssuers, crls, level, timestamp);
                return;
            }
            this.validateCert(crlIssuerCertPath, caOrCrlIssuers, crls, level, timestamp);
        }
        catch (CmsValidationException | GeneralSecurityException | AnnotatedException ex) {
            crl.setVerified(Boolean.FALSE);
            throw ex;
        }
        crl.setVerified(Boolean.TRUE);
    }

    private void checkLevel(AtomicInteger level) throws CmsValidationException {
        if (level.get() > 10) {
            throw new CmsValidationException(CmscbbErr.PKI_CRL_TOO_MUCH, "too many recursive calls of validateCrl");
        }
    }

    private void validateCertPathOfIssuer(CrlWrapper crl, List<CertWrapper> caOrCrlIssuers, List<CrlWrapper> crls, AtomicInteger level, boolean timestamp) throws GeneralSecurityException, AnnotatedException, CmsValidationException {
        CertPath crlIssuerCertPath = crl.getIssuerCertPath();
        boolean revoked = crl.isRevoked(crlIssuerCertPath.getTarget(), this.verificationTime, timestamp);
        if (revoked) {
            crl.setVerified(Boolean.FALSE);
            return;
        }
        CertPath certPathOfIssuer = crlIssuerCertPath.certPathOfIssuer();
        this.validateCert(certPathOfIssuer, caOrCrlIssuers, crls, level, timestamp);
        crl.setVerified(Boolean.TRUE);
    }

    private boolean crlHasValidated(CrlWrapper crl, CertPath crlIssuerCertPath) throws CmsValidationException {
        if (crl.getVerified() == null) {
            return false;
        }
        if (!crl.getIssuerCertPath().equals(crlIssuerCertPath)) {
            crl.setVerified(null);
            crl.setIssuerCertPath(null);
            return false;
        }
        if (crl.getVerified().booleanValue()) {
            return true;
        }
        throw new CmsValidationException(CmscbbErr.PKI_CRL_INVALID);
    }

    private void validateCert(CertPath targetCertPath, List<CertWrapper> caOrCrlIssuers, List<CrlWrapper> crls, AtomicInteger level, boolean timestamp) throws CmsValidationException, GeneralSecurityException, AnnotatedException {
        if (this.noNeedToValidate(targetCertPath)) {
            return;
        }
        this.validateSignature(targetCertPath);
        level.getAndIncrement();
        CertWrapper targetCert = targetCertPath.getTarget();
        List<CrlWrapper> trustedCrls = this.getTrustedCrls(targetCert, caOrCrlIssuers, crls, level, timestamp);
        CmscbbErr err = this.revokeCert(trustedCrls, targetCertPath, timestamp);
        targetCert.setStatusVerification(err);
        if (err != CmscbbErr.OK) {
            throw new CmsValidationException(err);
        }
    }

    private boolean noNeedToValidate(CertPath targetCertPath) throws CmsValidationException {
        if (targetCertPath.getTargetIsTrustAnchor()) {
            return true;
        }
        return this.getCertPathVerifyRes(targetCertPath);
    }

    private boolean getCertPathVerifyRes(CertPath targetCertPath) throws CmsValidationException {
        boolean res = targetCertPath.getSigVerification();
        res = res && targetCertPath.getStatusVerification();
        CertPath certPathOfIssuer = targetCertPath.certPathOfIssuer();
        res = res && certPathOfIssuer.getSigVerification();
        res = res && certPathOfIssuer.getStatusVerification();
        return res;
    }

    private List<CrlWrapper> getTrustedCrls(CertWrapper cert, List<CertWrapper> caOrCrlIssuers, List<CrlWrapper> crls, AtomicInteger level, boolean timestamp) throws GeneralSecurityException, AnnotatedException, CmsValidationException {
        Map<CrlWrapper.CrlIssuer, List<CrlWrapper>> matchedCrls = this.getCrls(cert, crls);
        LinkedList<CrlWrapper> trustedCrls = new LinkedList<CrlWrapper>();
        block0: for (List<CrlWrapper> crlList : matchedCrls.values()) {
            Collections.sort(crlList);
            for (CrlWrapper crl : crlList) {
                this.validateCrl(crl, caOrCrlIssuers, crls, level, timestamp);
                if (!crl.getVerified().booleanValue()) continue;
                trustedCrls.add(crl);
                continue block0;
            }
        }
        if (trustedCrls.isEmpty()) {
            throw new CertPathBuilderException(CmscbbErr.PKI_CRL_INVALID.toString());
        }
        return trustedCrls;
    }

    private CmscbbErr revokeCert(List<CrlWrapper> trustedCrls, CertPath targetCertPath, boolean timestamp) throws GeneralSecurityException {
        CmscbbErr err = CmscbbErr.PKI_CERT_NO_CRL;
        for (CrlWrapper crl : trustedCrls) {
            if (!crl.isRelatedCert(targetCertPath)) continue;
            boolean revoked = crl.isRevoked(targetCertPath.getTarget(), this.verificationTime, timestamp);
            if (!revoked) {
                err = CmscbbErr.OK;
                break;
            }
            err = CmscbbErr.PKI_CERT_REVOKED;
            break;
        }
        return err;
    }

    private CertWrapper getCrlIssuer(CrlWrapper crl, List<CertWrapper> caOrCrlIssuers) throws CmsValidationException {
        List<CertWrapper> trustAnchors = this.conf.getTrustAnchors(this.verificationTime);
        for (CertWrapper cert : trustAnchors) {
            if (!this.isCrlIssuer(cert, crl)) continue;
            return cert;
        }
        for (CertWrapper cert : caOrCrlIssuers) {
            if (!this.isCrlIssuer(cert, crl)) continue;
            return cert;
        }
        throw new CmsValidationException(CmscbbErr.PKI_CRL_INVALID_ISSUER, "found no issuer for CRL");
    }

    private boolean isCrlIssuer(CertWrapper cert, CrlWrapper crl) throws CmsValidationException {
        boolean isCrlIssuer = this.certIssueCrl(cert, crl);
        if (isCrlIssuer && !cert.hasUsages(2)) {
            throw new CmsValidationException(CmscbbErr.PKI_CRL_SIGNER_NO_USAGE_CRLSIGN);
        }
        return isCrlIssuer && cert.verifySignature(crl);
    }

    private boolean certIssueCrl(CertWrapper cert, CrlWrapper crl) {
        if (!cert.getSubject().equals((Object)crl.getCrlIssuer().getIssuer())) {
            return false;
        }
        return Arrays.equals(cert.getSki(), crl.getCrlIssuer().getAki());
    }

    private void validateSignature(CertPath certPath) throws CmsValidationException {
        List<CertWrapper> list = certPath.getAllCert();
        int size = list.size();
        for (int i = size - 1; i > 0; --i) {
            CertWrapper toCheck;
            CertWrapper ca = list.get(i);
            if (this.certHasChecked(ca, toCheck = list.get(i - 1))) continue;
            toCheck.setIssuerCert(ca);
            this.verifyToCheckCert(ca, toCheck);
        }
    }

    private boolean certHasChecked(CertWrapper ca, CertWrapper toCheck) throws CmsValidationException {
        if (ca == toCheck.getIssuerCert()) {
            CmscbbErr status = toCheck.getSigVerification();
            if (status == CmscbbErr.OK) {
                return true;
            }
            throw new CmsValidationException(CmscbbErr.PKI_CERT_VERIFY_FAILED);
        }
        return false;
    }

    private void verifyToCheckCert(CertWrapper ca, CertWrapper toCheck) throws CmsValidationException {
        if (!this.checkCriticalExtend(toCheck.getCert().getCriticalExtensionOIDs())) {
            toCheck.setSigVerification(CmscbbErr.PKI_CERT_VERIFY_FAILED);
            throw new CmsValidationException(CmscbbErr.PKI_CERT_UNKNOWN_CRITICAL_EXTNS);
        }
        if (!this.conf.getAlgorithmValidator().allowsAlgorithm(toCheck.getCertSignAlgo())) {
            toCheck.setSigVerification(CmscbbErr.PKI_CERT_SIG_ALGO);
            throw new CmsValidationException(toCheck.getSigVerification());
        }
        if (!ca.verifySignature(toCheck)) {
            toCheck.setSigVerification(CmscbbErr.PKI_CERT_VERIFY_FAILED);
            throw new CmsValidationException(toCheck.getSigVerification());
        }
        toCheck.setSigVerification(CmscbbErr.OK);
    }

    private Map<CrlWrapper.CrlIssuer, List<CrlWrapper>> getCrls(CertWrapper cert, List<CrlWrapper> crls) throws GeneralSecurityException {
        HashMap<CrlWrapper.CrlIssuer, List<CrlWrapper>> map = new HashMap<CrlWrapper.CrlIssuer, List<CrlWrapper>>();
        for (CrlWrapper crl : crls) {
            if (this.ignoreCrl(crl) || !crl.isCandidateForCert(cert)) continue;
            CrlWrapper.CrlIssuer crlIssuer = crl.getCrlIssuer();
            List<CrlWrapper> list = null;
            if (map.containsKey(crlIssuer)) {
                list = (List)map.get(crlIssuer);
            } else {
                list = new LinkedList();
                map.put(crlIssuer, list);
            }
            list.add(crl);
        }
        if (map.isEmpty()) {
            throw new CertPathBuilderException(CmscbbErr.PKI_CERT_NO_CRL.toString());
        }
        return map;
    }

    private boolean ignoreCrl(CrlWrapper crl) throws GeneralSecurityException {
        if (crl.getVerified() != null && !crl.getVerified().booleanValue()) {
            return true;
        }
        return this.verificationTime.after(crl.getNextUpdate());
    }

    private CertPath buildCertPath(CertWrapper target, List<CertWrapper> certs) throws CertPathBuilderException {
        List<CertWrapper> trustAnchors = this.conf.getTrustAnchors(this.verificationTime);
        if (target.isSelfSigned()) {
            return this.getSelfSignedCertPath(target, trustAnchors);
        }
        List<CertWrapper> intermediates = this.findInterMediates(trustAnchors, target, certs);
        CertWrapper targetCert = intermediates.size() == 0 ? target : intermediates.get(intermediates.size() - 1);
        for (CertWrapper ta : trustAnchors) {
            if (!ta.isCertIssuer(targetCert)) continue;
            return new CertPath(target, ta, intermediates);
        }
        throw new CertPathBuilderException(CmscbbErr.PKI_CERT_VERIFY_FAILED.toString());
    }

    private CertPath getSelfSignedCertPath(CertWrapper target, List<CertWrapper> trustAnchors) throws CertPathBuilderException {
        CertWrapper ta = null;
        for (CertWrapper m : trustAnchors) {
            if (!m.equals(target)) continue;
            ta = m;
            break;
        }
        if (ta == null) {
            throw new CertPathBuilderException("Failed to build the certificate chain");
        }
        return new CertPath(target, ta, null);
    }

    private List<CertWrapper> findInterMediates(List<CertWrapper> trustAnchors, CertWrapper targetCert, List<CertWrapper> certs) {
        CertWrapper issuer;
        LinkedList<CertWrapper> intermediates = new LinkedList<CertWrapper>();
        CertWrapper target = targetCert;
        while ((issuer = this.updateCertIssuer(trustAnchors, target)) == null && (issuer = this.updateCertIssuer(certs, target)) != null) {
            intermediates.add(issuer);
            target = issuer;
        }
        return intermediates;
    }

    private CertWrapper updateCertIssuer(List<CertWrapper> certs, CertWrapper target) {
        CertWrapper newIssuer = null;
        for (CertWrapper ca : certs) {
            if (!ca.isCertIssuer(target)) continue;
            newIssuer = ca;
            break;
        }
        return newIssuer;
    }
}

