/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.ssl;

import com.huawei.ism.tool.certbase.ssl.MySslX509TrustManager;
import com.huawei.ism.tool.certbase.utils.LocalTrustRootCertUtil;
import com.huawei.ism.tool.certbase.utils.RevokedCertUtil;
import java.io.File;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTrustSslSocketFactoryTool {
    private static final Logger log = LoggerFactory.getLogger(MyTrustSslSocketFactoryTool.class);

    @Deprecated
    public static SSLSocketFactory getMyTrustSSLFactory(String certDirPath, String protocol) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        return MyTrustSslSocketFactoryTool.getMyTrustSSLFactory(certDirPath, protocol, null);
    }

    public static SSLSocketFactory getTrustedSslFactory(String certDirPath, String protocol) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        return MyTrustSslSocketFactoryTool.getTrustedSslFactory(certDirPath, protocol, null);
    }

    @Deprecated
    public static SSLSocketFactory getMyTrustSSLFactory(String certDirPath, String protocol, String[] cipherSuites) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        log.info("start to getMyTrustSSLFactory...");
        RevokedCertUtil.addCrl(certDirPath + File.separator + "crl");
        return MyTrustSslSocketFactoryTool.getSslFactory(certDirPath, protocol, cipherSuites);
    }

    public static SSLSocketFactory getTrustedSslFactory(String certDirPath, String protocol, String[] cipherSuites) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        log.info("start to getMyTrustSslFactory with load crl...");
        MyTrustSslSocketFactoryTool.loadCrl(certDirPath);
        return MyTrustSslSocketFactoryTool.getSslFactory(certDirPath, protocol, cipherSuites);
    }

    private static void loadCrl(String certDirPath) {
        try {
            RevokedCertUtil.addCrl(certDirPath + File.separator + "crl", LocalTrustRootCertUtil.loadCerts(certDirPath));
        }
        catch (CRLException e) {
            log.error("Load crl error.", (Throwable)e);
        }
    }

    private static SSLSocketFactory getSslFactory(String certDirPath, String protocol, String[] cipherSuites) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        SSLContext sslContext;
        TrustManager[] mySslX509TrustManager = MyTrustSslSocketFactoryTool.getMySslX509TrustManager(certDirPath);
        try {
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, mySslX509TrustManager, SecureRandom.getInstanceStrong());
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setEnabledCipherSuites(ArrayUtils.isEmpty((Object[])cipherSuites) ? sslContext.getDefaultSSLParameters().getCipherSuites() : cipherSuites);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("getMyTrustSSLFactory error.", (Throwable)e);
            return null;
        }
        log.info("finished to getServerSSLFactory.");
        return sslContext.getSocketFactory();
    }

    public static TrustManager[] getMySslX509TrustManager(String certDirPathOrOneCertFilePath) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = LocalTrustRootCertUtil.getTrustKeyStore(certDirPathOrOneCertFilePath);
        if (null == trustStore) {
            throw new CertificateException("no trust manager found");
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(trustStore);
        TrustManager[] trustmanagers = MyTrustSslSocketFactoryTool.getWrappedTrustManagers(factory.getTrustManagers());
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        return trustmanagers;
    }

    private static TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        int len = tms.length;
        TrustManager[] x509TrustManagerWrapper = new MySslX509TrustManager[len];
        for (int i = 0; i < len; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            x509TrustManagerWrapper[i] = new MySslX509TrustManager((X509TrustManager)tms[i]);
        }
        return x509TrustManagerWrapper;
    }

    private MyTrustSslSocketFactoryTool() {
    }
}

