/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.utils;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.channel.upload.entity.IpCheckResult;
import com.huawei.ism.tool.channel.upload.entity.IpInfo;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.channel.utils.InternetInfoKeeper;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.https.conn.HttpsConnManager;
import com.huawei.ism.tool.https.entity.HttpProxy;
import com.huawei.ism.tool.https.entity.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

public class UserRegionCheckUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserRegionCheckUtil.class);
    private static final String CHINA_COUNTRY_CODE = "CN";
    private static final int CHECK_IS_OK = 0;
    private static final int CHECK_IS_NOT_OK = 1;
    private static final int OTHER_ERROR = 2;
    private static final int M_SIZE = 1024;
    private static final int ONE_HOUR = 3600;
    private static final int BASE_OFFSET = 8000;

    public static boolean isIpFromChina() {
        LOGGER.info("start to check upload ip...");
        LOGGER.info("Check isIpFromChina,Try connect the green cloud");
        String url = HttpsPropUtils.getUploadIpCheckRequestUrl();
        int checkResultCode = UserRegionCheckUtil.doUploadIpCheckConn(HttpsCertManager.getInstance().getSslServerSocketFactory(), url);
        if (checkResultCode == 2) {
            LOGGER.info("Check isIpFromChina,Try connect the yellow cloud");
            String spareUrl = HttpsPropUtils.getSpareUploadIpCheckRequestUrl();
            checkResultCode = UserRegionCheckUtil.doUploadIpCheckConn(HttpsCertManager.getInstance().getSslYellowServerSocketFactory(), spareUrl);
        }
        return checkResultCode != 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int doUploadIpCheckConn(SSLSocketFactory sslServerSocketFactory, String url) {
        HttpsURLConnection connection = UserRegionCheckUtil.getHttpsConnection(url, sslServerSocketFactory);
        if (connection == null) {
            LOGGER.error("Get https connection error");
            return 2;
        }
        try (InputStream in = connection.getInputStream();){
            StringBuffer resultJson = new StringBuffer();
            byte[] temp = new byte[1024];
            int len = 0;
            while ((len = in.read(temp)) != -1) {
                String tempStr = new String(temp, 0, len);
                resultJson.append(tempStr);
            }
            int n = UserRegionCheckUtil.checkIpInfo(resultJson.toString());
            return n;
        }
        catch (IOException e) {
            LOGGER.error("connection getContent IOException..");
            return 2;
        }
    }

    private static int checkIpInfo(String string) {
        IpCheckResult result = null;
        try {
            result = JSON.parseObject(string, IpCheckResult.class);
            if (null == result) {
                LOGGER.error("parse IpCheckResult is null");
                return 2;
            }
            int resultCode = result.getCode();
            if (resultCode != 0) {
                LOGGER.error("get ip info failed. code:" + resultCode + " .description:" + result.getDescription());
                return 2;
            }
            List<IpInfo> data = result.getData();
            if (null == data || data.isEmpty()) {
                LOGGER.error("no ip info can check..");
                return 2;
            }
            IpInfo ipInfo = data.get(0);
            String countryCode = ipInfo.getCountryCode();
            if (null == countryCode || "".equals(countryCode)) {
                LOGGER.info("countryCode is not queried..");
                return 2;
            }
            if (!CHINA_COUNTRY_CODE.equals(countryCode)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("ip is not in China..this countryCode:" + countryCode);
                }
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("check ip info failed.." + e);
            return 2;
        }
    }

    private static HttpsURLConnection getHttpsConnection(String checkDeviceRequestUrl, SSLSocketFactory sslServerSocketFactory) {
        HttpsConnection httpsConnection;
        HttpProxy proxy;
        boolean isUseProxy = InternetInfoKeeper.getInstance().getInternetParams().isUseProxy();
        HttpProxy httpProxy = proxy = isUseProxy ? InternetInfoKeeper.getInstance().getInternetParams().getHttpProxy() : null;
        if (InternetInfoKeeper.getInstance().isNonProxy(checkDeviceRequestUrl)) {
            proxy = null;
        }
        if (null == (httpsConnection = HttpsConnManager.getInstance().getHttpsConnByUrl(checkDeviceRequestUrl, proxy, sslServerSocketFactory)) || !httpsConnection.isSuccess()) {
            LOGGER.error("doUploadIpCheckConn connection failed\u3002\u3002");
            return null;
        }
        return httpsConnection.getConnection();
    }

    public static boolean isTimeZoneUTC8() {
        LOGGER.info("do check timezone..");
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15);
        int hourOffset = offset / 3600;
        if (hourOffset > 0) {
            int checkResult = hourOffset % 8000;
            if (checkResult == 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("this timezone is legitimate; " + cal.getTimeZone());
                }
                return true;
            }
            LOGGER.warn("this timezone is not legitimate; " + cal.getTimeZone());
            return false;
        }
        LOGGER.warn("this timezone is not legitimate; " + cal.getTimeZone());
        return false;
    }

    public static boolean isLanguageOk() {
        String userInfo = UserOpDataSaveUtil.getSupportUserInfo();
        String lantem = Locale.getDefault().toString().toLowerCase(Locale.ENGLISH).trim();
        String systemLang = System.getProperty("user.language");
        return !VerifyUtil.isEmpty((String)userInfo) && !userInfo.contains("isEnglish:true") && lantem.startsWith("zh") && "zh".equalsIgnoreCase(systemLang);
    }
}

