/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertPwdInfoKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertPwdInfoKeeper.class);
    private static final CertPwdInfoKeeper INSTANCE = new CertPwdInfoKeeper();
    private static final String CERT_PASSSTR = "channel.internet.cert.password";
    private static final String INTERNET_FILE_NAME = "callhome_internet_config.properties";
    private static final String INTERNET_FILE_NAME_ENETERPRISE = "callhome_internet_config_enterprise.properties";
    private static final String INTERNET_FILE_NAME_CARRIER = "callhome_internet_config_carrier.properties";
    private String certPwd = "";
    private long lastModifyTime;
    private static final String CARRIER = "Carrier";
    private static final String ENTERPRISE = "EnterPrise";
    private Properties internetPro = null;
    private final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertPwdInfoKeeper() {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.initCertPwdInfo();
        }
    }

    public static CertPwdInfoKeeper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCertPwdInfo() {
        this.internetPro = new Properties();
        File setupFile = this.retrieveFile(this.getClientInterInfoFilePath());
        if (null == setupFile) {
            LOGGER.error("get cert key file failed.");
            return;
        }
        this.lastModifyTime = setupFile.lastModified();
        BufferedInputStream is = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(setupFile);
            is = new BufferedInputStream(fileInputStream);
            this.internetPro.load(is);
            String pwd = HttpsPropUtils.parseString(this.internetPro, CERT_PASSSTR, "");
            this.setCertPwd(AESEncrypt.decrypt((String)pwd));
            this.internetPro.clear();
        }
        catch (IOException e) {
            try {
                LOGGER.error("create alarm setup file stream error! IOException");
                this.internetPro.clear();
            }
            catch (Throwable throwable) {
                this.internetPro.clear();
                StreamUtils.closeResource(null, is);
                StreamUtils.closeResource(null, (Closeable)fileInputStream);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)is);
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
            return;
        }
        StreamUtils.closeResource(null, (Closeable)is);
        StreamUtils.closeResource(null, (Closeable)fileInputStream);
    }

    public String getCertPwd() {
        return AESEncrypt.decrypt((String)this.certPwd);
    }

    public void setCertPwd(String certPwd) {
        this.certPwd = AESEncrypt.encrypt((String)certPwd);
    }

    private File retrieveFile(String filePath) {
        try {
            if (StringUtils.isNULLStr(filePath)) {
                return null;
            }
            File setupFile = new File(filePath);
            if (setupFile.exists()) {
                return setupFile;
            }
            return this.creatFile(setupFile);
        }
        catch (IOException e) {
            LOGGER.error("retrieve alarm setup file failed! IOException");
            return null;
        }
    }

    private File creatFile(File setupFile) throws IOException {
        boolean result = false;
        if (!setupFile.getParentFile().exists() && !(result = setupFile.getParentFile().mkdirs())) {
            return null;
        }
        result = setupFile.createNewFile();
        if (result) {
            return setupFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCertPwdInfo(String pwd, String role) {
        File internetFile = this.retrieveFile(this.getTmpInterInfoFilePathByRole(role));
        if (internetFile == null) {
            return false;
        }
        BufferedOutputStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(internetFile);
            out = new BufferedOutputStream(fileOutputStream);
            if (null != this.internetPro) {
                this.internetPro.setProperty(CERT_PASSSTR, StringUtils.isNULLStr(pwd) ? "" : pwd);
                this.internetPro.store(out, "");
            }
            if (null != this.internetPro) {
                this.internetPro.clear();
            }
        }
        catch (IOException e) {
            boolean bl;
            block8: {
                try {
                    LOGGER.error("open alarm setup file outputstream failed!IOException");
                    bl = false;
                    if (null == this.internetPro) break block8;
                    this.internetPro.clear();
                }
                catch (Throwable throwable) {
                    if (null != this.internetPro) {
                        this.internetPro.clear();
                    }
                    StreamUtils.closeResource(out, out);
                    StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
                    throw throwable;
                }
            }
            StreamUtils.closeResource((Flushable)out, (Closeable)out);
            StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
            return bl;
        }
        StreamUtils.closeResource((Flushable)out, (Closeable)out);
        StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
        return true;
    }

    public boolean reNameCertPwd() {
        boolean isSuccess;
        File certPwdFile = new File(this.getTmpInterInfoFilePath());
        File certTmpFile = new File(this.getTmpInterInfoFilePathByRole(ApplicationContext.getInstance().getUserRole()));
        if (!certTmpFile.exists()) {
            return false;
        }
        if (certPwdFile.exists() && !(isSuccess = certPwdFile.delete())) {
            return false;
        }
        return certTmpFile.renameTo(certPwdFile);
    }

    public boolean saveCertPwd(String pwd, String role) {
        this.setCertPwd(pwd);
        return this.saveCertPwdInfo(AESEncrypt.encrypt((String)pwd), role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentCertPwd() {
        String filePath = this.getClientInterInfoFilePath();
        if (StringUtils.isNULLStr(filePath)) {
            return this.getCertPwd();
        }
        File propFile = new File(filePath);
        boolean isDefaultFile = filePath.equals(ApplicationContext.getInstance().getDefaultCerPath() + INTERNET_FILE_NAME);
        if (propFile.lastModified() > this.lastModifyTime || isDefaultFile) {
            Object object = this.lock;
            synchronized (object) {
                this.initCertPwdInfo();
            }
        }
        return this.getCertPwd();
    }

    public String getClientInterInfoFilePath() {
        String defaultCerPath = ApplicationContext.getInstance().getDefaultCerPath();
        String filePath = this.getTmpInterInfoFilePath();
        File daultUserFile = new File(defaultCerPath + INTERNET_FILE_NAME);
        File curUserFile = new File(filePath);
        if (daultUserFile.exists() && (!curUserFile.exists() || curUserFile.length() == 0L)) {
            return defaultCerPath + INTERNET_FILE_NAME;
        }
        return filePath;
    }

    public String getTmpInterInfoFilePath() {
        String currWorkPath = ApplicationContext.getInstance().getCurrWorkPath();
        String filePath = new StringBuffer().append(currWorkPath).append("tmp").append(File.separator).append(INTERNET_FILE_NAME).toString();
        return filePath;
    }

    public String getTmpInterInfoFilePathByRole(String Role) {
        String currWorkPath = ApplicationContext.getInstance().getCurrWorkPath();
        if (CARRIER.equalsIgnoreCase(Role)) {
            return new StringBuffer().append(currWorkPath).append("tmp").append(File.separator).append(INTERNET_FILE_NAME_CARRIER).toString();
        }
        return new StringBuffer().append(currWorkPath).append("tmp").append(File.separator).append(INTERNET_FILE_NAME_ENETERPRISE).toString();
    }

    public String toString() {
        return "CertPwdInfoKeeper{lastModifyTime=" + this.lastModifyTime + "}";
    }
}

