/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.array;

import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class ArrayConvertUtils {
    private ArrayConvertUtils() {
    }

    public static <T> int[] toIntArray(List<T> original, ToIntFunction<T> function) {
        int[] res = new int[original.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = function.applyAsInt(original.get(i));
        }
        return res;
    }

    public static <T> double[] toDoubleArray(List<T> original, ToDoubleFunction<T> function) {
        double[] res = new double[original.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = function.applyAsDouble(original.get(i));
        }
        return res;
    }

    public static <T> long[] toLongArray(List<T> original, ToLongFunction<T> function) {
        long[] res = new long[original.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = function.applyAsLong(original.get(i));
        }
        return res;
    }
}

