/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.array;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;

public final class ArrayIndexOfUtils {
    private ArrayIndexOfUtils() {
    }

    public static int indexOfMax(@NotNull double[] array) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((double[])array));
        double max = array[0];
        int result = 0;
        for (int index = 1; index < array.length; ++index) {
            if (!(array[index] > max)) continue;
            max = array[index];
            result = index;
        }
        return result;
    }

    public static int indexOfMax(@NotNull BigDecimal[] array) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((Object[])array));
        BigDecimal max = array[0];
        int result = 0;
        for (int index = 1; index < array.length; ++index) {
            if (array[index].compareTo(max) <= 0) continue;
            max = array[index];
            result = index;
        }
        return result;
    }

    public static int indexOfMin(@NotNull double[] array) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((double[])array));
        double min = array[0];
        int result = 0;
        for (int index = 1; index < array.length; ++index) {
            if (!(array[index] < min)) continue;
            min = array[index];
            result = index;
        }
        return result;
    }

    public static int indexOfMin(@NotNull BigDecimal[] array) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((Object[])array));
        BigDecimal min = array[0];
        int result = 0;
        for (int index = 1; index < array.length; ++index) {
            if (array[index].compareTo(min) >= 0) continue;
            min = array[index];
            result = index;
        }
        return result;
    }
}

