/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.bytes;

import com.huawei.baize.base.common.Conditions;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.lang3.ArrayUtils;

public final class ByteConvertUtils {
    private static final int BYTE_MAX = 255;
    private static final int SHIFT_8 = 8;
    private static final int SHORT_BYTES = 2;
    private static final int INT_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private static final int HIGH_OFFSET_NUM = 240;
    private static final int LOW_OFFSET_NUM = 15;
    private static String[] binaryArray = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static String message = "index out Of bounds";

    private ByteConvertUtils() {
    }

    public static byte[] shortToByteArray(Short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    public static byte[] intToByteArray(int value) {
        byte[] bytes = new byte[4];
        for (int index = 1; index < 5; ++index) {
            bytes[index - 1] = (byte)(value >> (4 - index) * 8 & 0xFF);
        }
        return bytes;
    }

    public static byte[] longToByteArray(long value) {
        byte[] bytes = new byte[8];
        for (int index = 1; index < 9; ++index) {
            bytes[index - 1] = (byte)(value >> (8 - index) * 8 & 0xFFL);
        }
        return bytes;
    }

    public static byte[] floatToByteArray(float value) {
        return ByteConvertUtils.intToByteArray(Float.floatToIntBits(value));
    }

    public static byte[] doubleToByteArray(double value) {
        return ByteConvertUtils.longToByteArray(Double.doubleToRawLongBits(value));
    }

    public static byte[] charToByteArray(char value) {
        byte[] bytes = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    public static byte[] booleanToByteArray(boolean value) {
        byte[] byArray;
        if (value) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    public static String byteArrayToBinStr(byte[] bytes) {
        StringBuilder res = new StringBuilder();
        for (byte b : bytes) {
            int pos = (b & 0xF0) >> 4;
            res.append(binaryArray[pos]);
            pos = b & 0xF;
            res.append(binaryArray[pos]);
        }
        return res.toString();
    }

    public static Short byteArrayToShort(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 2, message);
        int sum = 0;
        for (int index = 0; index < 2; ++index) {
            sum += (bytes[index] & 0xFF) << (1 - index) * 8;
        }
        return (short)sum;
    }

    public static Short byteArrayToShort(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= offset + 2, message);
        return (short)(((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF));
    }

    public static int byteArrayToInt(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 4, "size={}", ArrayUtils.getLength((Object)bytes));
        int sum = 0;
        for (int index = 1; index < 5; ++index) {
            sum += (bytes[index - 1] & 0xFF) << (4 - index) * 8;
        }
        return sum;
    }

    public static int byteArrayToInt(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= offset + 4, message, ArrayUtils.getLength((Object)bytes));
        int sum = 0;
        for (int index = 1; index < 5; ++index) {
            sum += (bytes[offset + index - 1] & 0xFF) << (4 - index) * 8;
        }
        return sum;
    }

    public static long byteArrayToLong(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 8, "size={}", ArrayUtils.getLength((Object)bytes));
        long res = (long)bytes[0] << 56;
        for (int index = 1; index < 8; ++index) {
            res += (long)(bytes[index] & 0xFF) << (8 - index - 1) * 8;
        }
        return res;
    }

    public static long byteArrayToLong(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 8 + offset, "size={}", ArrayUtils.getLength((Object)bytes));
        long res = (long)bytes[offset] << 56;
        for (int index = 1; index < 8; ++index) {
            res += (long)(bytes[index + offset] & 0xFF) << (8 - index - 1) * 8;
        }
        return res;
    }

    public static float byteArrayToFloat(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 4, message);
        return Float.intBitsToFloat(ByteConvertUtils.byteArrayToInt(bytes));
    }

    public static float byteArrayToFloat(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 4 + offset, message);
        return Float.intBitsToFloat(ByteConvertUtils.byteArrayToInt(bytes, offset));
    }

    public static double byteArrayToDouble(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 8, message);
        return Double.longBitsToDouble(ByteConvertUtils.byteArrayToLong(bytes));
    }

    public static double byteArrayToDouble(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 8 + offset, message);
        return Double.longBitsToDouble(ByteConvertUtils.byteArrayToLong(bytes, offset));
    }

    public static char byteArrayToChar(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 2, message);
        return (char)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static char byteArrayToChar(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 2 + offset, message);
        return (char)((bytes[offset] & 0xFF) << 8 | bytes[1 + offset] & 0xFF);
    }

    public static boolean byteArrayToBoolean(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 1, message);
        return bytes[0] != 0;
    }

    public static boolean byteArrayToBoolean(byte[] bytes, int offset) {
        Conditions.requireArgument(ArrayUtils.getLength((Object)bytes) >= 1 + offset, message);
        return bytes[offset] != 0;
    }

    public static byte[] charArrayToByteArray(char[] chars, String charsetCode) throws CharacterCodingException {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName(charsetCode).newEncoder().encode(charBuffer);
        byte[] byteArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byteArray, 0, byteArray.length);
        return byteArray;
    }

    public static char[] byteArrayToCharArray(byte[] bytes, String charsetCode) throws CharacterCodingException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName(charsetCode).newDecoder().decode(byteBuffer);
        return Arrays.copyOf(charBuffer.array(), charBuffer.limit());
    }

    public static String encodeToBase64(byte[] bytes) {
        return Arrays.toString(Base64.getEncoder().encode(bytes));
    }
}

