/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.character;

import com.huawei.baize.base.array.ArrayConcatUtils;

public final class CharacterUtils {
    private static final char[] CHARS_ALPHA_NUMERIC;
    private static final char[] CHARS_LOWER_ALPHA;
    private static final char[] CHARS_UPPER_ALPHA;
    private static final char[] CHARS_ALPHA;
    private static final char[] CHARS_NUMERIC;
    private static final char[] CHARS_SPECIAL;
    private static final char[] CHARS_EXCLUDE_CONFUSED_ALPHA_NUMERIC;
    private static final char[] CHARS_EXCLUDE_CONFUSED_ALPHA;
    private static final char[] CHARS_EXCLUDE_CONFUSE_UPPER_ALPHA;
    private static final char[] CHARS_EXCLUDE_CONFUSED_NUMERIC;

    private CharacterUtils() {
    }

    public static boolean isChineseChar(char ch) {
        Character.UnicodeScript sc = Character.UnicodeScript.of(ch);
        return sc == Character.UnicodeScript.HAN;
    }

    public static boolean isChinesePunctuation(char ch) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
        if (Character.UnicodeBlock.GENERAL_PUNCTUATION.equals(ub) || Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(ub) || Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS.equals(ub) || Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS.equals(ub)) {
            return true;
        }
        return Character.UnicodeBlock.VERTICAL_FORMS.equals(ub);
    }

    public static char[] numericChars() {
        return (char[])CHARS_NUMERIC.clone();
    }

    public static char[] alphaNumericChars() {
        return (char[])CHARS_ALPHA_NUMERIC.clone();
    }

    public static char[] upperAlphaChars() {
        return (char[])CHARS_UPPER_ALPHA.clone();
    }

    public static char[] lowerAlphaChars() {
        return (char[])CHARS_LOWER_ALPHA.clone();
    }

    public static char[] alphaChars() {
        return (char[])CHARS_ALPHA.clone();
    }

    public static char[] specialChars() {
        return (char[])CHARS_SPECIAL.clone();
    }

    public static char[] alphaExcludeConfusedChars() {
        return (char[])CHARS_EXCLUDE_CONFUSED_ALPHA.clone();
    }

    public static char[] alphaNumericExcludeConfusedChars() {
        return (char[])CHARS_EXCLUDE_CONFUSED_ALPHA_NUMERIC.clone();
    }

    static {
        CHARS_LOWER_ALPHA = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        CHARS_UPPER_ALPHA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        CHARS_ALPHA = ArrayConcatUtils.concatAll(CHARS_LOWER_ALPHA, new char[][]{CHARS_UPPER_ALPHA});
        CHARS_NUMERIC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        CHARS_ALPHA_NUMERIC = ArrayConcatUtils.concatAll(CHARS_ALPHA, new char[][]{CHARS_NUMERIC});
        CHARS_SPECIAL = new char[]{'!', '$', '*', '+', '-', '.', '=', '?', '@', '^', '_', '|', '~'};
        CHARS_EXCLUDE_CONFUSE_UPPER_ALPHA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        CHARS_EXCLUDE_CONFUSED_ALPHA = ArrayConcatUtils.concatAll(CHARS_LOWER_ALPHA, new char[][]{CHARS_EXCLUDE_CONFUSE_UPPER_ALPHA});
        CHARS_EXCLUDE_CONFUSED_NUMERIC = new char[]{'2', '3', '4', '5', '6', '7', '8', '9'};
        CHARS_EXCLUDE_CONFUSED_ALPHA_NUMERIC = ArrayConcatUtils.concatAll(CHARS_LOWER_ALPHA, CHARS_EXCLUDE_CONFUSE_UPPER_ALPHA, CHARS_EXCLUDE_CONFUSED_NUMERIC);
    }
}

