/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.math.Binary;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class CollectionSubsetUtils {
    private static final int BASE_NUMBER = 2;

    private CollectionSubsetUtils() {
    }

    public static <T> List<List<T>> subset(@NotNull List<T> parent) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(parent));
        int length = (int)Math.pow(2.0, parent.size());
        ArrayList<List<T>> list = new ArrayList<List<T>>(length - 1);
        for (int i = 1; i <= length - 1; ++i) {
            char[] binary = Binary.binary(i);
            List subList = IntStream.range(0, binary.length).filter(id -> Binary.bitCheck(binary, id)).mapToObj(id -> parent.get(id)).collect(Collectors.toList());
            list.add(subList);
        }
        return list;
    }

    public static <T> List<List<T>> subset(@NotNull T[] arrays) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((Object[])arrays));
        int length = (int)Math.pow(2.0, arrays.length);
        ArrayList<List<T>> list = new ArrayList<List<T>>(length - 1);
        for (int i = 1; i <= length - 1; ++i) {
            char[] binary = Binary.binary(i);
            List subList = IntStream.range(0, binary.length).filter(idx -> Binary.bitCheck(binary, idx)).mapToObj(idx -> arrays[idx]).collect(Collectors.toList());
            list.add(subList);
        }
        return list;
    }
}

