/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection.list;

import com.huawei.baize.base.common.Conditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<List<T>> splitByIndex(List<T> list, int ... indexes) {
        int length = indexes.length;
        ArrayList<List<T>> result = new ArrayList<List<T>>(length + 1);
        if (length == 0) {
            result.add(list);
            return result;
        }
        Conditions.requireArgument(indexes[0] >= 0);
        Conditions.requireArgument(indexes[length - 1] < list.size());
        Conditions.requireArgument(ArrayUtils.isSorted((int[])indexes));
        List<T> res = ListUtils.subList(list, 0, indexes[0]);
        if (!res.isEmpty()) {
            result.add(res);
        }
        if (length == 1) {
            res = ListUtils.subList(list, indexes[length - 1] + 1, list.size());
            if (!res.isEmpty()) {
                result.add(res);
            }
            return result;
        }
        for (int i = 0; i < length - 1; ++i) {
            res = ListUtils.subList(list, indexes[i] + 1, indexes[i + 1]);
            if (res.isEmpty()) continue;
            result.add(res);
        }
        res = ListUtils.subList(list, indexes[length - 1] + 1, list.size());
        if (!res.isEmpty()) {
            result.add(res);
        }
        return result;
    }

    private static <T> List<T> subList(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            return Collections.emptyList();
        }
        return list.subList(fromIndex, toIndex);
    }
}

