/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.common.Conditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ApproximateSets {
    private static final BigDecimal BIGDECIMAL_ZERO = BigDecimal.valueOf(0.0);
    private final BigDecimal errorRange;
    private boolean postive;

    public ApproximateSets(double errRange) {
        this.errorRange = BigDecimal.valueOf(errRange);
    }

    public <T> BigDecimal getMin(List<T> list, double target, Function<T, BigDecimal> get) {
        List<T> res = this.getlist(list, target, get);
        BigDecimal tar = BigDecimal.valueOf(target);
        BigDecimal resnum = get.apply(res.get(0));
        for (int i = 1; i < res.size(); ++i) {
            BigDecimal reserr = resnum.subtract(tar);
            BigDecimal curnum = get.apply(res.get(i));
            BigDecimal curerr = curnum.subtract(tar);
            if (!this.postive) {
                if (curerr.compareTo(reserr) >= 0) continue;
                resnum = get.apply(res.get(i));
                continue;
            }
            if (curerr.compareTo(reserr) <= 0) continue;
            resnum = get.apply(res.get(i));
        }
        return resnum;
    }

    public <T> List<T> getlist(List<T> list, double target, Function<T, BigDecimal> get) {
        Conditions.requireArgument(!list.isEmpty());
        BigDecimal tar = BigDecimal.valueOf(target);
        return list.stream().filter(item -> {
            BigDecimal val = (BigDecimal)get.apply(item);
            BigDecimal err = val.subtract(tar);
            if (!this.postive) {
                return err.compareTo(BIGDECIMAL_ZERO) >= 0 && this.errorRange.compareTo(err) >= 0;
            }
            return BIGDECIMAL_ZERO.compareTo(err) >= 0 && this.errorRange.compareTo(err.abs()) >= 0;
        }).collect(Collectors.toList());
    }

    public ApproximateSets postive(boolean postive) {
        this.postive = postive;
        return this;
    }
}

