/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.regex.RegexExpression;
import com.huawei.baize.base.regex.RegexMatchUtils;

public final class DigitUtils {
    private DigitUtils() {
    }

    public static boolean isDigit(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_REGEX_PATTERN, digit);
    }

    public static boolean isDigit(String digit, int length) {
        return DigitUtils.isDigit(digit, length, Integer.MIN_VALUE);
    }

    public static boolean isDigit(String digit, int start, int end) {
        String endStr = end == Integer.MAX_VALUE ? "," : (end == Integer.MIN_VALUE ? "" : "," + end);
        String regex = "^\\d{" + start + endStr + "}$";
        return RegexMatchUtils.matches(regex, digit);
    }

    public static boolean isDigitLeast(String digit, int length) {
        return DigitUtils.isDigit(digit, length, Integer.MAX_VALUE);
    }

    public static boolean isDigitAllowZero(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_ALLOW_ZERO_PATTERN, digit);
    }

    public static boolean isPositiveInteger(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_POSITIVE_INTEGER_NOT_ZERO_PATTERN, digit);
    }

    public static boolean isNegativeInteger(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NEGATIVE_INTEGER_NOT_ZERO_PATTERN, digit);
    }

    public static boolean isIntegerNotZero(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_INTEGER_NOT_ZERO_PATTERN, digit);
    }

    public static boolean isInteger(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_INTEGER_PATTERN, digit);
    }

    public static boolean isNotNegativeInteger(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NOT_NEGATIVE_INTEGER_PATTERN, digit);
    }

    public static boolean isNotPositiveInteger(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NOT_INTEGER_PATTERN, digit);
    }

    public static boolean isHex(String hexStr) {
        return RegexMatchUtils.matches(RegexExpression.HEX_STR_PATTERN, hexStr);
    }
}

