/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.math.MathUtils;
import com.huawei.baize.base.regex.RegexMatchUtils;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;

public final class IntervalUtils {
    private static final String NUMBER_REGEX = "^(\\-|\\+)?\\d+(\\.\\d+)?$";
    private static final String HALF_INTERVAL_REGEX = "^([<>\u2264\u2265\\[\\(]{1}(-?\\d+.?\\d*\\%?))$";

    private IntervalUtils() {
    }

    public static boolean isInTheInterval(String dataValue, String interval) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{dataValue, interval})) {
            return false;
        }
        if (!RegexMatchUtils.matches(NUMBER_REGEX, dataValue)) {
            return false;
        }
        StringBuffer buff = new StringBuffer();
        for (String limit : interval.split("U")) {
            buff.append('(');
            buff.append(IntervalUtils.getFormulaByInterval(dataValue, limit, " && "));
            buff.append(")||");
        }
        String allLimitInvel = buff.toString();
        String formula = allLimitInvel.substring(0, allLimitInvel.lastIndexOf("||"));
        ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
        try {
            if (jse.eval(formula) instanceof Boolean) {
                return (Boolean)jse.eval(formula);
            }
            return false;
        }
        catch (ScriptException t) {
            return false;
        }
    }

    private static String getFormulaByInterval(String dataValue, String interval, String connector) {
        StringBuffer buff = new StringBuffer();
        for (String halfInterval : interval.split(",")) {
            buff.append(IntervalUtils.getFormulaByHalfInterval(halfInterval.trim(), dataValue)).append(connector);
        }
        String limitInvel = buff.toString();
        limitInvel = limitInvel.substring(0, limitInvel.lastIndexOf(connector));
        return limitInvel;
    }

    private static String getFormulaByHalfInterval(String halfInterval, String dataValue) {
        if (halfInterval.contains("\u221e")) {
            return "1 == 1";
        }
        StringBuffer formula = new StringBuffer();
        String data = "";
        String opera = "";
        if (halfInterval.matches(HALF_INTERVAL_REGEX)) {
            opera = halfInterval.substring(0, 1);
            data = halfInterval.substring(1);
        } else {
            opera = halfInterval.substring(halfInterval.length() - 1);
            data = halfInterval.substring(0, halfInterval.length() - 1);
        }
        double value = MathUtils.dealPercentConvertToDecimal(data);
        formula.append(dataValue).append(' ').append(opera).append(' ').append(value);
        String result = formula.toString();
        return result.replace("[", ">=").replace("(", ">").replace("]", "<=").replace(")", "<").replace("\u2264", "<=").replace("\u2265", ">=");
    }
}

