/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class MathUtils {
    private static final BigDecimal LOG_2 = BigDecimal.valueOf(Math.log(2.0));
    private static final int PRECISION = 9;
    private static final int TWO = 2;
    private static final int SCALE = 3;
    private static final double EPSILON = 1.0E-6;
    private static final double DOUBLE_ZERO = Double.parseDouble("0.0");
    private static final int MOD = 10;
    private static final int ONE_HUNDRED_TIMES = 100;
    private static final String NUMBER_REGEX = "^(\\-|\\+)?\\d+(\\.\\d+)?%?$";

    private MathUtils() {
    }

    public static boolean doubleComp(double val1, double val2) {
        return Math.abs(val1 - val2) < 1.0E-6;
    }

    public static boolean floatComp(float val1, float val2) {
        return (double)Math.abs(val1 - val2) < 1.0E-6;
    }

    public static boolean isZero(double val1) {
        return Math.abs(val1 - DOUBLE_ZERO) < 1.0E-6;
    }

    @NotNull
    public static int[] slice(long value) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        long val = value;
        do {
            list.add((int)(val % 10L));
        } while ((val /= 10L) != 0L);
        Collections.reverse(list);
        return ArrayUtils.toPrimitive((Integer[])list.toArray(new Integer[0]));
    }

    public static long split(@NotNull int[] slices) {
        ArrayUtils.reverse((int[])slices);
        long value = 0L;
        for (int i = 0; i < slices.length; ++i) {
            value += (long)slices[i] * (long)Math.pow(10.0, i);
        }
        return value;
    }

    public static BigDecimal log2(double numY) {
        return BigDecimal.valueOf(Math.log(numY)).divide(LOG_2, new MathContext(9, RoundingMode.HALF_UP)).setScale(3, RoundingMode.HALF_UP);
    }

    public static BigDecimal logX(double numX, double numY) {
        return BigDecimal.valueOf(Math.log(numY)).divide(BigDecimal.valueOf(Math.log(numX)), new MathContext(9, RoundingMode.HALF_UP)).setScale(3, RoundingMode.HALF_UP);
    }

    public static double quotient(double numX, double numY) {
        if (MathUtils.isZero(numX)) {
            return DOUBLE_ZERO;
        }
        return numX * Double.parseDouble("1.0") / numY;
    }

    public static BigDecimal quotient(BigDecimal numX, BigDecimal numY) {
        return numX.divide(numY, new MathContext(9, RoundingMode.HALF_UP)).setScale(3, RoundingMode.HALF_UP);
    }

    public static BigDecimal entropy(double[] datas) {
        BigDecimal ent = BigDecimal.valueOf(DOUBLE_ZERO);
        for (double dat : datas) {
            if (MathUtils.isZero(dat)) continue;
            BigDecimal data = BigDecimal.valueOf(dat);
            data = data.multiply(MathUtils.log2(dat)).multiply(BigDecimal.valueOf(-1L));
            ent = ent.add(data);
        }
        return ent.setScale(3, RoundingMode.HALF_UP);
    }

    public static BigDecimal entropyGain(BigDecimal entropy, double[] conditions, List<double[]> conditionColors) {
        BigDecimal gain = new BigDecimal(entropy.doubleValue());
        for (int i = 0; i < conditions.length; ++i) {
            BigDecimal cond = new BigDecimal(conditions[i]);
            BigDecimal ent = MathUtils.entropy(conditionColors.get(i));
            gain = gain.subtract(cond.multiply(ent));
        }
        return gain.setScale(3, RoundingMode.HALF_UP);
    }

    public static int greatestCommonDivisor(int ... numbers) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])numbers));
        if (numbers.length == 1) {
            return numbers[0];
        }
        if (numbers.length == 2) {
            return MathUtils.greatestCommonDivisor(numbers[0], numbers[1]);
        }
        int greatestCommonDivisor = MathUtils.greatestCommonDivisor(numbers[0], numbers[1]);
        for (int i = 2; i < numbers.length; ++i) {
            greatestCommonDivisor = MathUtils.greatestCommonDivisor(greatestCommonDivisor, numbers[i]);
        }
        return greatestCommonDivisor;
    }

    private static int greatestCommonDivisor(int num1, int num2) {
        if (0 == num1 || 0 == num2) {
            return 0;
        }
        return num1 % num2 == 0 ? num2 : MathUtils.greatestCommonDivisor(num2, num1 % num2);
    }

    public static int leastCommonMultiple(int ... numbers) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])numbers));
        if (numbers.length == 1) {
            return numbers[0];
        }
        if (numbers.length == 2) {
            return MathUtils.leastCommonMultiple(numbers[0], numbers[1]);
        }
        int leastCommonMultiple = MathUtils.leastCommonMultiple(numbers[0], numbers[1]);
        for (int i = 2; i < numbers.length; ++i) {
            leastCommonMultiple = MathUtils.leastCommonMultiple(leastCommonMultiple, numbers[i]);
        }
        return leastCommonMultiple;
    }

    private static int leastCommonMultiple(int num1, int num2) {
        int greatestCommonDivisor = MathUtils.greatestCommonDivisor(num1, num2);
        return greatestCommonDivisor == 0 ? 0 : num1 * num2 / greatestCommonDivisor;
    }

    public static double dealPercentConvertToDecimal(String str) {
        Conditions.requireArgument(StringUtils.isNotEmpty((CharSequence)str));
        Conditions.requireArgument(str.matches(NUMBER_REGEX));
        double num = 0.0;
        if (str.contains("%")) {
            String newStr = str.substring(0, str.length() - 1);
            num = Double.parseDouble(newStr) / 100.0;
        } else {
            num = Double.parseDouble(str);
        }
        return num;
    }
}

