/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.common.Conditions;
import java.math.BigDecimal;

public final class Section {
    private final double min;
    private final double max;
    private final boolean left;
    private final boolean right;

    Section(double min, boolean left, double max, boolean right) {
        Conditions.requireArgument(min < max, "{} must be less than {}", min, max);
        this.min = min;
        this.max = max;
        this.left = left;
        this.right = right;
    }

    static boolean isOverlap(Section section1, Section section2) {
        Section[] secs = Section.sort(section1, section2);
        return secs[0].max > secs[1].min || secs[0].max == secs[1].min && (secs[0].right || secs[1].left);
    }

    static Section merge(Section section1, Section section2) {
        Section[] secs = Section.sort(section1, section2);
        double min = Math.min(secs[0].min, secs[1].min);
        double max = Math.max(secs[0].max, secs[1].max);
        boolean left = BigDecimal.valueOf(min).compareTo(BigDecimal.valueOf(secs[0].min)) == 0 ? secs[0].left : secs[1].left;
        boolean right = BigDecimal.valueOf(max).compareTo(BigDecimal.valueOf(secs[0].max)) == 0 ? secs[0].right : secs[1].right;
        return new Section(min, left, max, right);
    }

    private static Section[] sort(Section section1, Section section2) {
        Section[] sectionArray;
        if (section1.min < section2.min) {
            Section[] sectionArray2 = new Section[2];
            sectionArray2[0] = section1;
            sectionArray = sectionArray2;
            sectionArray2[1] = section2;
        } else {
            Section[] sectionArray3 = new Section[2];
            sectionArray3[0] = section2;
            sectionArray = sectionArray3;
            sectionArray3[1] = section1;
        }
        return sectionArray;
    }

    boolean isBetween(double val) {
        boolean inRightBorder = val < this.max || this.right && val == this.max;
        boolean inLeftBorder = val > this.min || this.left && val == this.min;
        return inRightBorder && inLeftBorder;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section other = (Section)o;
        if (Double.compare(this.getMin(), other.getMin()) != 0) {
            return false;
        }
        if (Double.compare(this.getMax(), other.getMax()) != 0) {
            return false;
        }
        if (this.isLeft() != other.isLeft()) {
            return false;
        }
        return this.isRight() == other.isRight();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        result = result * 59 + (this.isLeft() ? 79 : 97);
        result = result * 59 + (this.isRight() ? 79 : 97);
        return result;
    }
}

