/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.character.CharacterUtils;
import com.huawei.baize.base.common.Conditions;
import java.security.SecureRandom;
import java.util.UUID;

public final class SecureRandomUtils {
    private SecureRandomUtils() {
    }

    public static byte[] getRandomBytes(int length) {
        Conditions.requireArgument(length > 0, "The length of byte array must be positive.");
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    public static int getRandomInt() {
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        return secureRandom.nextInt();
    }

    public static int getRandomInt(int bound) {
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        return secureRandom.nextInt(bound);
    }

    public static int getRandomInt(int min, int max) {
        Conditions.requireArgument(min < max);
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        return secureRandom.nextInt(max - min) + min;
    }

    public static long getRandomLong() {
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        return secureRandom.nextLong();
    }

    public static float getRandomFloat() {
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        return secureRandom.nextFloat();
    }

    public static float getRandomFloat(float min, float max) {
        Conditions.requireArgument(min < max);
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        float factor = max - min;
        return secureRandom.nextFloat() * factor + min;
    }

    public static String getRandomString(int length, @NotNull char[] charSet) {
        Conditions.requireArgument(length >= 0);
        Conditions.requireArgument(charSet.length > 0);
        SecureRandom secureRandom = SecureRandomUtils.getSecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int loop = 0; loop < length; ++loop) {
            int index = secureRandom.nextInt(charSet.length);
            sb.append(charSet[index]);
        }
        return sb.toString();
    }

    public static String getRandomAlphaNumericString(int length) {
        Conditions.requireArgument(length >= 0);
        return SecureRandomUtils.getRandomString(length, CharacterUtils.alphaNumericChars());
    }

    public static String getRandomGUID() {
        return UUID.randomUUID().toString();
    }

    private static SecureRandom getSecureRandom() {
        return new SecureRandom();
    }
}

