/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import com.huawei.baize.base.math.calculator.CalculatorTools;
import com.huawei.baize.base.math.calculator.IntOperation;
import com.huawei.baize.base.math.calculator.LogicNotOperation;
import com.huawei.baize.base.math.calculator.LogicOperation;
import com.huawei.baize.base.math.calculator.MathOperation;
import com.huawei.baize.base.math.calculator.RelationOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

final class CalculatorProcessor {
    private static final int INITIAL_CAPACITY = 8;
    final Map<String, String> hashMap = new HashMap<String, String>(8);
    final List<String> keys = new ArrayList<String>();

    CalculatorProcessor() {
    }

    String calculate(String express) {
        int lastLeftIndex = StringUtils.lastIndexOf((CharSequence)express, (int)40);
        if (lastLeftIndex != -1) {
            return this.calcWithBrace(express, lastLeftIndex);
        }
        String result = this.calcWithoutBrace(express);
        if (this.keys.contains(result)) {
            return this.hashMap.get(result);
        }
        return result;
    }

    long calculateToLong(String express) {
        return Math.round(Double.parseDouble(this.calculate(express)));
    }

    private String calcWithBrace(String express, int lastLeftIndex) {
        int rightIndex = express.indexOf(41, lastLeftIndex);
        if (rightIndex == -1) {
            throw new IllegalArgumentException("operator is wrong.");
        }
        String subExp = express.substring(lastLeftIndex + 1, rightIndex);
        if (lastLeftIndex != 0 && express.charAt(lastLeftIndex - 1) == '!') {
            return this.calcNot(express, lastLeftIndex, rightIndex, subExp);
        }
        String result = this.calcWithoutBrace(subExp);
        if (this.keys.contains(result)) {
            return this.hashMap.get(result);
        }
        String op = express.substring(0, lastLeftIndex) + result + express.substring(rightIndex + 1);
        return this.calculate(op);
    }

    private String calcNot(String express, int leftIndex, int rightIndex, String subExp) {
        String result = this.calcWithoutBrace(subExp);
        String op = express.substring(0, leftIndex) + result + express.substring(rightIndex + 1);
        return this.calculate(op);
    }

    private String calcWithoutBrace(String express) {
        if (this.keys.contains(express)) {
            return express;
        }
        String op = CalculatorTools.replaceNegative(express);
        int lastLeftIndex = StringUtils.lastIndexOf((CharSequence)op, (int)63);
        if (lastLeftIndex != -1) {
            return this.calcCondition(op, lastLeftIndex);
        }
        return this.calcExpress(op);
    }

    private String calcCondition(String express, int leftIndex) {
        int rightIndex = express.indexOf(58, leftIndex);
        if (rightIndex == -1) {
            throw new IllegalArgumentException("operator is wrong.");
        }
        int nextRightIndex = express.indexOf(58, rightIndex + 1);
        String leftExp = express.substring(leftIndex + 1, rightIndex);
        String rightExp = nextRightIndex == -1 ? express.substring(rightIndex + 1) : express.substring(rightIndex + 1, nextRightIndex);
        String op = this.updateExpress(leftIndex, express, nextRightIndex, leftExp, rightExp);
        return this.calcWithoutBrace(op);
    }

    private String updateExpress(int leftIndex, String express, int nextRightIndex, String leftExp, String rightExp) {
        String op;
        int preLeftIndex = express.lastIndexOf(63, leftIndex - 1);
        int preRightIndex = express.lastIndexOf(58, leftIndex - 1);
        int splitIndex = Math.max(preRightIndex, preLeftIndex);
        String result = this.calcExpress(express.substring(splitIndex + 1, leftIndex));
        if (result.equals(Boolean.toString(true))) {
            op = this.getExpress(express, nextRightIndex, leftExp, splitIndex);
        } else if (result.equals(Boolean.toString(false))) {
            op = this.getExpress(express, nextRightIndex, rightExp, splitIndex);
        } else {
            throw new IllegalArgumentException("operator is wrong.");
        }
        return op;
    }

    private String getExpress(String express, int nextRightIndex, String result, int preLeftIndex) {
        if (nextRightIndex == -1) {
            return express.substring(0, preLeftIndex + 1) + result;
        }
        return express.substring(0, preLeftIndex + 1) + result + express.substring(nextRightIndex);
    }

    private String calcExpress(String express) {
        String op = CalculatorTools.replaceNegative(express);
        List<String> ops = CalculatorTools.getOperatorList(op = CalculatorTools.transformLogicNot(op));
        if (ops.isEmpty()) {
            return express;
        }
        return this.cale(op, ops);
    }

    private String cale(String express, List<String> ops) {
        List<Object> obs = CalculatorTools.getObjectList(express);
        IntOperation.calculate(ops, obs);
        if (ops.isEmpty()) {
            return String.valueOf(((Number)obs.get(0)).intValue());
        }
        MathOperation.calculate(ops, obs);
        if (ops.isEmpty()) {
            return String.valueOf(obs.get(0));
        }
        RelationOperation.calculate(ops, obs, this.hashMap);
        if (ops.isEmpty()) {
            return String.valueOf(obs.get(0));
        }
        LogicOperation.calculate(ops, obs);
        if (ops.isEmpty()) {
            return String.valueOf(obs.get(0));
        }
        LogicNotOperation.calculate(ops, obs);
        if (ops.isEmpty()) {
            return String.valueOf(obs.get(0));
        }
        return express;
    }
}

