/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import com.huawei.baize.base.math.DigitFloatUtils;
import com.huawei.baize.base.math.DigitUtils;
import com.huawei.baize.base.math.calculator.IntOperation;
import com.huawei.baize.base.math.calculator.LogicNotOperation;
import com.huawei.baize.base.math.calculator.LogicOperation;
import com.huawei.baize.base.math.calculator.MathOperation;
import com.huawei.baize.base.math.calculator.RelationOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CalculatorTools {
    private static final Pattern NEGATIVE_NUM_STR_PATTERN = Pattern.compile("@[0-9]|[0-9]|[a-z]");
    private static final Pattern OPER_PATTERN = Pattern.compile(CalculatorTools.generateOperatorRegex());

    private CalculatorTools() {
    }

    static String transformLogicNot(String express) {
        String op = express;
        if ("!false".equals(op) || "!true".equals(op)) {
            return op;
        }
        if (op.contains("!false")) {
            op = op.replace("!false", Boolean.toString(true));
        } else if (op.contains("!true")) {
            op = op.replace("!true", Boolean.toString(false));
        } else {
            return op;
        }
        return CalculatorTools.transformLogicNot(op);
    }

    static List<String> getOperatorList(String express) {
        return Arrays.stream(NEGATIVE_NUM_STR_PATTERN.split(express)).map(CalculatorTools::extractOper).flatMap(Arrays::stream).filter(CalculatorTools::isOperatorSign).collect(Collectors.toList());
    }

    static List<Object> getObjectList(String express) {
        return Arrays.stream(OPER_PATTERN.split(express)).filter(str -> !str.isEmpty()).map(CalculatorTools::backToNegative).map(CalculatorTools::parseObj).collect(Collectors.toList());
    }

    private static Object parseObj(String str) {
        if (DigitFloatUtils.isDigitFloat(str)) {
            return Double.parseDouble(str);
        }
        if (DigitUtils.isPositiveInteger(str) || DigitUtils.isNotPositiveInteger(str)) {
            return Long.parseLong(str);
        }
        if (str.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (str.equals(Boolean.FALSE.toString())) {
            return false;
        }
        return str;
    }

    static String replaceNegative(String express) {
        if (express.indexOf(45) == -1) {
            return express;
        }
        char[] expArray = express.toCharArray();
        for (int i = 0; i < expArray.length; ++i) {
            if (!CalculatorTools.isNegativeSign(expArray, i)) continue;
            expArray[i] = 64;
        }
        return String.valueOf(expArray);
    }

    private static boolean isNegativeSign(char[] opers, int idx) {
        return opers[idx] == '-' && (idx == 0 || !Character.isDigit(opers[idx - 1]));
    }

    private static List<String> getOperatorSign() {
        return Stream.of(MathOperation.MATH_OPERS, RelationOperation.RELATION_OPERS, LogicOperation.LOGIC_OPERS, IntOperation.INT_OPERS, LogicNotOperation.NOT_OPERS).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static String generateOperatorRegex() {
        return CalculatorTools.getOperatorSign().stream().collect(Collectors.joining("|\\", "\\", "")).replace("\\||", "\\|{2}");
    }

    private static boolean isOperatorSign(String str) {
        return CalculatorTools.getOperatorSign().contains(str);
    }

    private static String[] extractOper(String str) {
        int index = str.indexOf(35);
        if (index == -1) {
            index = str.indexOf(33);
        }
        if (index != -1) {
            String preOper = str.substring(0, index);
            String nextOper = str.substring(index);
            return new String[]{preOper, nextOper};
        }
        return new String[]{str};
    }

    private static String backToNegative(String oper) {
        return oper.replace('@', '-');
    }
}

