/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class IntOperation {
    private static final IntOperation[] INT_OPS = new IntOperation[]{new IntOperation(String.valueOf('#'), Number::longValue)};
    static final List<String> INT_OPERS = Arrays.stream(INT_OPS).map(IntOperation::getOper).collect(Collectors.toList());
    private String oper;
    private Function<Number, Number> calc;

    static void calculate(List<String> ops, List<Object> obs) {
        if (CollectionUtils.containsAny(ops, INT_OPERS)) {
            for (IntOperation oper : INT_OPS) {
                int i = 0;
                while (i < ops.size()) {
                    String curOp = ops.get(i);
                    if (oper.getOper().equals(curOp)) {
                        IntOperation.calcIntSet(ops, obs, i);
                        continue;
                    }
                    ++i;
                }
            }
        }
    }

    private static void calcIntSet(List<String> ops, List<Object> obs, int i) {
        String oper = ops.remove(i);
        Number rValue = (Number)obs.remove(i);
        Number result = IntOperation.cale(rValue, oper);
        obs.add(i, result);
    }

    private static Number cale(Number value, String op) {
        return Arrays.stream(INT_OPS).filter(ob -> ob.getOper().equals(op)).findAny().map(ob -> ob.getCalc().apply(value)).orElseThrow(() -> new IllegalArgumentException("not support: " + op));
    }

    public String getOper() {
        return this.oper;
    }

    public Function<Number, Number> getCalc() {
        return this.calc;
    }

    public IntOperation(String oper, Function<Number, Number> calc) {
        this.oper = oper;
        this.calc = calc;
    }
}

