/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class MathOperation {
    private static final MathOperation[][] MATH_OPS = new MathOperation[][]{{new MathOperation("^", (lv, rv) -> Math.pow(lv.doubleValue(), rv.doubleValue()))}, {new MathOperation("*", MathOperation::times), new MathOperation("/", MathOperation::divide), new MathOperation("%", MathOperation::mod)}, {new MathOperation("+", MathOperation::plus), new MathOperation("-", MathOperation::minus)}};
    static final List<String> MATH_OPERS = Arrays.stream(MATH_OPS).flatMap(Arrays::stream).map(MathOperation::getOper).collect(Collectors.toList());
    private String oper;
    private BiFunction<Number, Number, Number> calc;

    static void calculate(List<String> ops, List<Object> obs) {
        if (CollectionUtils.containsAny(ops, MATH_OPERS)) {
            for (MathOperation[] opers : MATH_OPS) {
                int i = 0;
                while (i < ops.size()) {
                    String curOp = ops.get(i);
                    if (Arrays.stream(opers).map(MathOperation::getOper).anyMatch(oper -> oper.equals(curOp))) {
                        MathOperation.calcMathSet(ops, obs, i);
                        continue;
                    }
                    ++i;
                }
            }
        }
    }

    private static void calcMathSet(List<String> ops, List<Object> obs, int i) {
        String oper = ops.remove(i);
        Number lValue = (Number)obs.remove(i);
        Number rValue = (Number)obs.remove(i);
        Number result = MathOperation.cale(lValue, rValue, oper);
        obs.add(i, result);
    }

    private static Number cale(Number lvalue, Number rValue, String op) {
        return Arrays.stream(MATH_OPS).flatMap(Arrays::stream).filter(ob -> ob.getOper().equals(op)).findAny().map(ob -> ob.getCalc().apply(lvalue, rValue)).orElseThrow(() -> new IllegalArgumentException("not support: " + op));
    }

    private static Number times(Number lv, Number rv) {
        if (lv instanceof Double && rv instanceof Double) {
            return lv.doubleValue() * rv.doubleValue();
        }
        if (lv instanceof Long && rv instanceof Double) {
            return (double)lv.longValue() * rv.doubleValue();
        }
        if (lv instanceof Double && rv instanceof Long) {
            return lv.doubleValue() * (double)rv.longValue();
        }
        return lv.longValue() * rv.longValue();
    }

    private static Number divide(Number lv, Number rv) {
        if (lv instanceof Double && rv instanceof Double) {
            return lv.doubleValue() / rv.doubleValue();
        }
        if (lv instanceof Long && rv instanceof Double) {
            return (double)lv.longValue() / rv.doubleValue();
        }
        if (lv instanceof Double && rv instanceof Long) {
            return lv.doubleValue() / (double)rv.longValue();
        }
        return lv.longValue() / rv.longValue();
    }

    private static Number mod(Number lv, Number rv) {
        if (lv instanceof Double && rv instanceof Double) {
            return lv.doubleValue() % rv.doubleValue();
        }
        if (lv instanceof Long && rv instanceof Double) {
            return (double)lv.longValue() % rv.doubleValue();
        }
        if (lv instanceof Double && rv instanceof Long) {
            return lv.doubleValue() % (double)rv.longValue();
        }
        return lv.longValue() % rv.longValue();
    }

    private static Number plus(Number lv, Number rv) {
        if (lv instanceof Double && rv instanceof Double) {
            return lv.doubleValue() + rv.doubleValue();
        }
        if (lv instanceof Long && rv instanceof Double) {
            return (double)lv.longValue() + rv.doubleValue();
        }
        if (lv instanceof Double && rv instanceof Long) {
            return lv.doubleValue() + (double)rv.longValue();
        }
        return lv.longValue() + rv.longValue();
    }

    private static Number minus(Number lv, Number rv) {
        if (lv instanceof Double && rv instanceof Double) {
            return lv.doubleValue() - rv.doubleValue();
        }
        if (lv instanceof Long && rv instanceof Double) {
            return (double)lv.longValue() - rv.doubleValue();
        }
        if (lv instanceof Double && rv instanceof Long) {
            return lv.doubleValue() - (double)rv.longValue();
        }
        return lv.longValue() - rv.longValue();
    }

    public String getOper() {
        return this.oper;
    }

    public BiFunction<Number, Number, Number> getCalc() {
        return this.calc;
    }

    public MathOperation(String oper, BiFunction<Number, Number, Number> calc) {
        this.oper = oper;
        this.calc = calc;
    }
}

