/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import com.huawei.baize.base.math.MathUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class RelationOperation {
    private static final RelationOperation[] RELATION_OPS = new RelationOperation[]{new RelationOperation("<=", (lv, rv) -> lv.doubleValue() <= rv.doubleValue()), new RelationOperation("<", (lv, rv) -> lv.doubleValue() < rv.doubleValue()), new RelationOperation(">=", (lv, rv) -> lv.doubleValue() >= rv.doubleValue()), new RelationOperation(">", (lv, rv) -> lv.doubleValue() > rv.doubleValue()), new RelationOperation("==", (lv, rv) -> MathUtils.doubleComp(lv.doubleValue(), rv.doubleValue())), new RelationOperation("!=", (lv, rv) -> !MathUtils.doubleComp(lv.doubleValue(), rv.doubleValue()))};
    static final List<String> RELATION_OPERS = Arrays.stream(RELATION_OPS).map(RelationOperation::getOper).collect(Collectors.toList());
    private String oper;
    private BiFunction<Number, Number, Boolean> calc;

    static void calculate(List<String> ops, List<Object> obs, Map<String, String> hashMap) {
        if (CollectionUtils.containsAny(ops, RELATION_OPERS)) {
            for (RelationOperation oper : RELATION_OPS) {
                int i = 0;
                while (i < ops.size()) {
                    String curOp = ops.get(i);
                    if (oper.getOper().equals(curOp)) {
                        if (i + 1 < ops.size() && RELATION_OPERS.contains(ops.get(i + 1))) {
                            throw new IllegalArgumentException("operator is wrong.");
                        }
                        RelationOperation.calcRelationSet(ops, obs, i, hashMap);
                        continue;
                    }
                    ++i;
                }
            }
        }
    }

    private static void calcRelationSet(List<String> ops, List<Object> obs, int i, Map<String, String> hashMap) {
        String oper = ops.remove(i);
        Object lObj = obs.remove(i);
        Object rObj = obs.remove(i);
        if (lObj instanceof String && rObj instanceof String) {
            boolean result = RelationOperation.strCmp((String)lObj, (String)rObj, hashMap);
            RelationOperation.calcStrCmp(obs, i, oper, result);
        } else if (lObj instanceof Number && rObj instanceof Number) {
            boolean result = RelationOperation.cale((Number)lObj, (Number)rObj, oper);
            obs.add(i, result);
        } else if (lObj instanceof Boolean && rObj instanceof Boolean) {
            RelationOperation.calcBoolCmp(obs, i, oper, (Boolean)lObj, (Boolean)rObj);
        } else {
            throw new IllegalArgumentException("operator is wrong.");
        }
    }

    private static void calcStrCmp(List<Object> obs, int i, String oper, boolean result) {
        if (oper.equals("==")) {
            obs.add(i, result);
        } else if (oper.equals("!=")) {
            obs.add(i, !result);
        } else {
            throw new IllegalArgumentException("operator is wrong.");
        }
    }

    private static boolean strCmp(String lValue, String rValue, Map<String, String> hashMap) {
        if (!hashMap.containsKey(lValue) || !hashMap.containsKey(rValue)) {
            throw new IllegalArgumentException("operator is wrong.");
        }
        return hashMap.get(lValue).equals(hashMap.get(rValue));
    }

    private static void calcBoolCmp(List<Object> obs, int i, String oper, Boolean lbool, Boolean rbool) {
        if (oper.equals("==")) {
            obs.add(i, lbool.booleanValue() == rbool.booleanValue());
        } else if (oper.equals("!=")) {
            obs.add(i, lbool.booleanValue() != rbool.booleanValue());
        } else {
            throw new IllegalArgumentException("operator is wrong.");
        }
    }

    private static Boolean cale(Number lvalue, Number rValue, String op) {
        return Arrays.stream(RELATION_OPS).filter(ob -> ob.getOper().equals(op)).findAny().map(ob -> ob.getCalc().apply(lvalue, rValue)).orElseThrow(() -> new IllegalArgumentException("not support: " + op));
    }

    public String getOper() {
        return this.oper;
    }

    public BiFunction<Number, Number, Boolean> getCalc() {
        return this.calc;
    }

    public RelationOperation(String oper, BiFunction<Number, Number, Boolean> calc) {
        this.oper = oper;
        this.calc = calc;
    }
}

